/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.bulkexecutor.internal;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.documentdb.DocumentClient;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.RequestOptions;
import com.microsoft.azure.documentdb.StoredProcedureResponse;
import com.microsoft.azure.documentdb.bulkexecutor.internal.BulkDeleteQuerySpec;
import com.microsoft.azure.documentdb.bulkexecutor.internal.BulkDeleteStoredProcedureResponse;
import com.microsoft.azure.documentdb.bulkexecutor.internal.ExceptionUtils;
import com.microsoft.azure.documentdb.repackaged.com.google.common.util.concurrent.AtomicDouble;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchDeleter {
    private final String partitionKeyRangeId;
    private final DocumentClient client;
    public AtomicInteger numberOfDocumentsDeleted;
    public AtomicDouble totalRequestUnitsConsumed;
    private final String bulkDeleteSprocLink;
    private final BulkDeleteQuerySpec querySpec;
    private RequestOptions requestOptions;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(BatchDeleter.class);

    public BatchDeleter(String partitionKeyRangeId, DocumentClient client, String bulkDeleteSprocLink, BulkDeleteQuerySpec querySpec) {
        this.partitionKeyRangeId = partitionKeyRangeId;
        this.client = client;
        this.bulkDeleteSprocLink = bulkDeleteSprocLink;
        this.querySpec = querySpec;
        this.numberOfDocumentsDeleted = new AtomicInteger();
        this.totalRequestUnitsConsumed = new AtomicDouble();
        this.requestOptions = new RequestOptions();
        class RequestOptionsInternal
        extends RequestOptions {
            RequestOptionsInternal(String partitionKeyRangeId) {
                this.setPartitionKeyRengeId(partitionKeyRangeId);
            }
        }
        this.requestOptions = new RequestOptionsInternal(partitionKeyRangeId);
    }

    public int getNumberOfDocumentsDeleted() {
        return this.numberOfDocumentsDeleted.get();
    }

    public double getTotalRequestUnitsConsumed() {
        return this.totalRequestUnitsConsumed.get();
    }

    public Callable<Void> executeDelete() {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                boolean isDeleteCompleted = false;
                while (!isDeleteCompleted) {
                    boolean isThrottled = false;
                    Duration retryAfter = Duration.ZERO;
                    StoredProcedureResponse storedProcedureResponse = null;
                    try {
                        storedProcedureResponse = BatchDeleter.this.client.executeStoredProcedure(BatchDeleter.this.bulkDeleteSprocLink, BatchDeleter.this.requestOptions, new Object[]{BatchDeleter.this.querySpec, null});
                        BulkDeleteStoredProcedureResponse bulkDeleteResponse = BatchDeleter.this.parseFrom(storedProcedureResponse);
                        if (bulkDeleteResponse != null) {
                            if (!bulkDeleteResponse.done) {
                                logger.warn("pki {} | Delete execution did not complete, retrying..", (Object)BatchDeleter.this.partitionKeyRangeId);
                            }
                            isDeleteCompleted = bulkDeleteResponse.done;
                            BatchDeleter.this.numberOfDocumentsDeleted.addAndGet(bulkDeleteResponse.count);
                            BatchDeleter.this.totalRequestUnitsConsumed.addAndGet(storedProcedureResponse.getRequestCharge());
                        } else {
                            logger.warn("pki {} Failed to receive response", (Object)BatchDeleter.this.partitionKeyRangeId);
                        }
                    }
                    catch (DocumentClientException e) {
                        if (ExceptionUtils.isThrottled(e)) {
                            logger.debug("pki {} Throttled on partition range id", (Object)BatchDeleter.this.partitionKeyRangeId);
                            isThrottled = true;
                            retryAfter = Duration.ofMillis(e.getRetryAfterInMilliseconds());
                        }
                        if (ExceptionUtils.isTimedOut(e)) {
                            logger.debug("pki {} Request timed out", (Object)BatchDeleter.this.partitionKeyRangeId);
                        }
                        if (ExceptionUtils.isUnavailable(e)) {
                            logger.debug("pki {} Service unavailable", (Object)BatchDeleter.this.partitionKeyRangeId);
                        }
                        if (ExceptionUtils.isGone(e)) {
                            if (ExceptionUtils.isSplit(e)) {
                                String errorMessage = String.format("pki %s is undergoing split, please retry shortly after re-initializing BulkExecutor", BatchDeleter.this.partitionKeyRangeId);
                                logger.error(errorMessage);
                                throw new RuntimeException(errorMessage);
                            }
                            String errorMessage = String.format("pki %s is gone, please retry shortly after re-initializing BulkExecutor", BatchDeleter.this.partitionKeyRangeId);
                            logger.error(errorMessage);
                            throw new RuntimeException(errorMessage);
                        }
                        String errorMessage = String.format("pki %s failed to delete. Exception was %s. Status code was %s", BatchDeleter.this.partitionKeyRangeId, e.getMessage(), e.getStatusCode());
                        logger.error(errorMessage, (Throwable)e);
                        throw new RuntimeException(e);
                    }
                    catch (Exception e) {
                        String errorMessage = String.format("pki %s Failed to delete. Exception was %s", BatchDeleter.this.partitionKeyRangeId, e.getMessage());
                        logger.error(errorMessage, (Throwable)e);
                        throw new RuntimeException(errorMessage, e);
                    }
                    if (!isThrottled) continue;
                    try {
                        logger.debug("pki {} throttled going to sleep for {} millis ", (Object)BatchDeleter.this.partitionKeyRangeId, (Object)retryAfter.toMillis());
                        Thread.sleep(retryAfter.toMillis());
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                return null;
            }
        };
    }

    private BulkDeleteStoredProcedureResponse parseFrom(StoredProcedureResponse storedProcResponse) throws JsonParseException, JsonMappingException, IOException {
        String res = storedProcResponse.getResponseAsString();
        logger.debug("Bulk Delete for Partition Key Range Id {}: Stored Proc Response as String {}", (Object)this.partitionKeyRangeId, (Object)res);
        if (StringUtils.isEmpty((CharSequence)res)) {
            return null;
        }
        return (BulkDeleteStoredProcedureResponse)objectMapper.readValue(res, BulkDeleteStoredProcedureResponse.class);
    }
}

