/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.bulkexecutor.internal;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.microsoft.azure.documentdb.DocumentClient;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.RequestOptions;
import com.microsoft.azure.documentdb.StoredProcedureResponse;
import com.microsoft.azure.documentdb.bulkexecutor.BulkImportFailure;
import com.microsoft.azure.documentdb.bulkexecutor.internal.BatchOperator;
import com.microsoft.azure.documentdb.bulkexecutor.internal.BulkImportStoredProcedureOptions;
import com.microsoft.azure.documentdb.bulkexecutor.internal.BulkImportStoredProcedureResponse;
import com.microsoft.azure.documentdb.bulkexecutor.internal.ExceptionUtils;
import com.microsoft.azure.documentdb.bulkexecutor.internal.OperationMetrics;
import com.microsoft.azure.documentdb.repackaged.com.google.common.base.Stopwatch;
import com.microsoft.azure.documentdb.repackaged.com.google.common.util.concurrent.AtomicDouble;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchInserter
extends BatchOperator {
    public AtomicInteger numberOfDocumentsImported;
    public AtomicDouble totalRequestUnitsConsumed;
    public List<Object> badInputDocuments;
    private final List<List<String>> batchesToInsert;
    private final String bulkImportSprocLink;
    private List<String> documentsFailedToImportDueToSplits;
    private List<BulkImportFailure> documentsFailedToImport;
    private final BulkImportStoredProcedureOptions storedProcOptions;
    private final int maxRetryCountOnTimeouts = 5;
    private final Logger logger = LoggerFactory.getLogger(BatchInserter.class);

    public BatchInserter(String partitionKeyRangeId, List<List<String>> batchesToInsert, DocumentClient client, String bulkImportSprocLink, BulkImportStoredProcedureOptions options) {
        this.partitionKeyRangeId = partitionKeyRangeId;
        this.batchesToInsert = batchesToInsert;
        this.client = client;
        this.bulkImportSprocLink = bulkImportSprocLink;
        this.storedProcOptions = options;
        this.numberOfDocumentsImported = new AtomicInteger();
        this.totalRequestUnitsConsumed = new AtomicDouble();
        this.badInputDocuments = Collections.synchronizedList(new ArrayList());
        this.documentsFailedToImportDueToSplits = Collections.synchronizedList(new ArrayList());
        this.documentsFailedToImport = Collections.synchronizedList(new ArrayList());
        class RequestOptionsInternal
        extends RequestOptions {
            RequestOptionsInternal(String partitionKeyRangeId) {
                this.setPartitionKeyRengeId(partitionKeyRangeId);
            }
        }
        this.requestOptions = new RequestOptionsInternal(partitionKeyRangeId);
    }

    public int getNumberOfDocumentsImported() {
        return this.numberOfDocumentsImported.get();
    }

    public double getTotalRequestUnitsConsumed() {
        return this.totalRequestUnitsConsumed.get();
    }

    public List<Object> getBadInputDocuments() {
        return this.badInputDocuments;
    }

    public List<String> getDocumentsFailedToImportDueToSplits() {
        return this.documentsFailedToImportDueToSplits;
    }

    public List<BulkImportFailure> getDocumentsFailedToImport() {
        return this.documentsFailedToImport;
    }

    @Override
    public Iterator<Callable<OperationMetrics>> miniBatchExecutionCallableIterator() {
        Stream<Callable> stream = this.batchesToInsert.stream().map(miniBatch -> new Callable<OperationMetrics>(){

            @Override
            public OperationMetrics call() {
                Stopwatch stopwatch = Stopwatch.createStarted();
                double requestUnitsCounsumed = 0.0;
                int numberOfThrottles = 0;
                int currentDocumentIndex = 0;
                try {
                    BatchInserter.this.logger.debug("pki {} importing mini batch started", (Object)BatchInserter.this.partitionKeyRangeId);
                    int numberOfTimeouts = 0;
                    boolean timedOut = false;
                    while (currentDocumentIndex < miniBatch.size() && !BatchInserter.this.cancel) {
                        BulkImportFailure bulkImportFailure;
                        BatchInserter.this.logger.debug("pki {} inside for loop, currentDocumentIndex", (Object)BatchInserter.this.partitionKeyRangeId, (Object)currentDocumentIndex);
                        String[] docBatch = miniBatch.subList(currentDocumentIndex, miniBatch.size()).toArray(new String[0]);
                        boolean isThrottled = false;
                        Duration retryAfter = Duration.ZERO;
                        try {
                            StoredProcedureResponse response;
                            BatchInserter.this.logger.debug("pki {}, Trying to import minibatch of {} documents", (Object)BatchInserter.this.partitionKeyRangeId, (Object)docBatch.length);
                            if (!timedOut) {
                                response = BatchInserter.this.client.executeStoredProcedure(BatchInserter.this.bulkImportSprocLink, BatchInserter.this.requestOptions, new Object[]{docBatch, BatchInserter.this.storedProcOptions, null});
                            } else {
                                BulkImportStoredProcedureOptions modifiedStoredProcOptions = new BulkImportStoredProcedureOptions(((BatchInserter)BatchInserter.this).storedProcOptions.disableAutomaticIdGeneration, ((BatchInserter)BatchInserter.this).storedProcOptions.softStopOnConflict, ((BatchInserter)BatchInserter.this).storedProcOptions.systemCollectionId, ((BatchInserter)BatchInserter.this).storedProcOptions.enableBsonSchema, true, ((BatchInserter)BatchInserter.this).storedProcOptions.softStopOnBadRequest);
                                response = BatchInserter.this.client.executeStoredProcedure(BatchInserter.this.bulkImportSprocLink, BatchInserter.this.requestOptions, new Object[]{docBatch, modifiedStoredProcOptions, null});
                            }
                            BulkImportStoredProcedureResponse bulkImportResponse = BatchInserter.this.parseFrom(response);
                            if (bulkImportResponse != null) {
                                if (bulkImportResponse.errorCode != 0) {
                                    BatchInserter.this.logger.warn("pki {} Received response error code {}", (Object)BatchInserter.this.partitionKeyRangeId, (Object)bulkImportResponse.errorCode);
                                    if (bulkImportResponse.errorCode == 400) {
                                        BatchInserter.this.badInputDocuments.add(bulkImportResponse.failedDoc);
                                        ++currentDocumentIndex;
                                    } else if (bulkImportResponse.count == 0) {
                                        BulkImportFailure bulkImportFailure2 = new BulkImportFailure();
                                        bulkImportFailure2.getDocumentsFailedToImport().addAll(Arrays.asList(docBatch));
                                        bulkImportFailure2.setBulkImportFailureException(new RuntimeException(String.format("Stored proc returned failure %s", bulkImportResponse.errorCode)));
                                        BatchInserter.this.documentsFailedToImport.add(bulkImportFailure2);
                                        BatchInserter.this.cancel = true;
                                    }
                                }
                                double requestCharge = response.getRequestCharge();
                                currentDocumentIndex += bulkImportResponse.count;
                                BatchInserter.this.numberOfDocumentsImported.addAndGet(bulkImportResponse.count);
                                requestUnitsCounsumed += requestCharge;
                                BatchInserter.this.totalRequestUnitsConsumed.addAndGet(requestCharge);
                            } else {
                                BatchInserter.this.logger.warn("pki {} Failed to receive response", (Object)BatchInserter.this.partitionKeyRangeId);
                            }
                        }
                        catch (DocumentClientException e) {
                            BatchInserter.this.logger.debug("pki {} Importing minibatch failed", (Object)BatchInserter.this.partitionKeyRangeId, (Object)e);
                            if (ExceptionUtils.isThrottled(e)) {
                                BatchInserter.this.logger.debug("pki {} Throttled on partition range id", (Object)BatchInserter.this.partitionKeyRangeId);
                                ++numberOfThrottles;
                                isThrottled = true;
                                retryAfter = Duration.ofMillis(e.getRetryAfterInMilliseconds());
                            } else if (ExceptionUtils.isTimedOut(e)) {
                                BatchInserter.this.logger.debug("pki {} Request timed out", (Object)BatchInserter.this.partitionKeyRangeId);
                                if (numberOfTimeouts < 5) {
                                    timedOut = true;
                                    ++numberOfTimeouts;
                                } else {
                                    BulkImportFailure bulkImportFailure3 = new BulkImportFailure();
                                    bulkImportFailure3.getDocumentsFailedToImport().addAll(Arrays.asList(docBatch));
                                    bulkImportFailure3.setBulkImportFailureException((Exception)((Object)e));
                                    BatchInserter.this.documentsFailedToImport.add(bulkImportFailure3);
                                    BatchInserter.this.cancel = true;
                                }
                            } else if (ExceptionUtils.isUnavailable(e)) {
                                BatchInserter.this.logger.debug("pki {} Service unavailable", (Object)BatchInserter.this.partitionKeyRangeId);
                                BatchInserter.this.documentsFailedToImportDueToSplits.addAll(Arrays.asList(docBatch));
                                BatchInserter.this.logger.warn("Received Service unavailable exception when importing a mini-batch for partition key range: " + BatchInserter.this.partitionKeyRangeId + ". This mini-batch will be retried on the next invocation.");
                                BatchInserter.this.logger.debug("ServiceUnavailable. Original exception message was: {} ", (Object)e.getMessage());
                                BatchInserter.this.cancel = true;
                            } else if (ExceptionUtils.isGone(e)) {
                                if (ExceptionUtils.isSplit(e)) {
                                    BatchInserter.this.documentsFailedToImportDueToSplits.addAll(Arrays.asList(docBatch));
                                    BatchInserter.this.logger.warn("Received a GoneException on Partition range id " + BatchInserter.this.partitionKeyRangeId + " as the partition was completing a split | Storing the mini batch and retrying");
                                    BatchInserter.this.logger.debug("GoneException due to split. Original exception message was: {} ", (Object)e.getMessage());
                                } else {
                                    BatchInserter.this.documentsFailedToImportDueToSplits.addAll(Arrays.asList(docBatch));
                                    BatchInserter.this.logger.warn("Received a GoneException on Partition range id " + BatchInserter.this.partitionKeyRangeId + " | Storing the mini batch and retrying");
                                    BatchInserter.this.logger.debug("GonException - general. Original exception message was: {} ", (Object)e.getMessage());
                                }
                                BatchInserter.this.cancel = true;
                            } else {
                                String errorMessage = String.format("pki %s failed to import mini-batch. Exception was %s. Status code was %s", BatchInserter.this.partitionKeyRangeId, e.getMessage(), e.getStatusCode());
                                BatchInserter.this.logger.error(errorMessage, (Throwable)e);
                                bulkImportFailure = new BulkImportFailure();
                                bulkImportFailure.getDocumentsFailedToImport().addAll(Arrays.asList(docBatch));
                                bulkImportFailure.setBulkImportFailureException((Exception)((Object)e));
                                BatchInserter.this.documentsFailedToImport.add(bulkImportFailure);
                                BatchInserter.this.cancel = true;
                            }
                        }
                        catch (IllegalStateException e) {
                            BatchInserter.this.documentsFailedToImportDueToSplits.addAll(Arrays.asList(docBatch));
                            BatchInserter.this.logger.warn("Received IllegalStateException since partition key range: " + BatchInserter.this.partitionKeyRangeId + " was split or Gone. | Storing the mini batch and retrying");
                            BatchInserter.this.cancel = true;
                        }
                        catch (Exception e) {
                            String errorMessage = String.format("pki %s Failed to import mini-batch. Exception was %s", BatchInserter.this.partitionKeyRangeId, e.getMessage());
                            BatchInserter.this.logger.error(errorMessage, (Throwable)e);
                            bulkImportFailure = new BulkImportFailure();
                            bulkImportFailure.getDocumentsFailedToImport().addAll(Arrays.asList(docBatch));
                            bulkImportFailure.setBulkImportFailureException(new RuntimeException(errorMessage, e));
                            BatchInserter.this.documentsFailedToImport.add(bulkImportFailure);
                            BatchInserter.this.cancel = true;
                        }
                        if (!isThrottled) continue;
                        try {
                            BatchInserter.this.logger.debug("pki {} throttled going to sleep for {} millis ", (Object)BatchInserter.this.partitionKeyRangeId, (Object)retryAfter.toMillis());
                            Thread.sleep(retryAfter.toMillis());
                        }
                        catch (InterruptedException e) {
                            BulkImportFailure bulkImportFailure4 = new BulkImportFailure();
                            bulkImportFailure4.getDocumentsFailedToImport().addAll(Arrays.asList(docBatch));
                            bulkImportFailure4.setBulkImportFailureException(new RuntimeException(e));
                            BatchInserter.this.documentsFailedToImport.add(bulkImportFailure4);
                            BatchInserter.this.cancel = true;
                        }
                    }
                    BatchInserter.this.logger.debug("pki {} completed", (Object)BatchInserter.this.partitionKeyRangeId);
                }
                catch (Exception e) {
                    BulkImportFailure bulkImportFailure = new BulkImportFailure();
                    bulkImportFailure.getDocumentsFailedToImport().addAll(miniBatch);
                    bulkImportFailure.setBulkImportFailureException(e);
                    BatchInserter.this.documentsFailedToImport.add(bulkImportFailure);
                    BatchInserter.this.cancel = true;
                }
                stopwatch.stop();
                OperationMetrics insertMetrics = new OperationMetrics(currentDocumentIndex, stopwatch.elapsed(), requestUnitsCounsumed, numberOfThrottles);
                return insertMetrics;
            }
        });
        return stream.iterator();
    }

    private BulkImportStoredProcedureResponse parseFrom(StoredProcedureResponse storedProcResponse) throws JsonParseException, JsonMappingException, IOException {
        String res = storedProcResponse.getResponseAsString();
        this.logger.debug("MiniBatch Insertion for Partition Key Range Id {}: Stored Proc Response as String {}", (Object)this.partitionKeyRangeId, (Object)res);
        if (StringUtils.isEmpty((CharSequence)res)) {
            return null;
        }
        return (BulkImportStoredProcedureResponse)objectMapper.readValue(res, BulkImportStoredProcedureResponse.class);
    }
}

