/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.bulkexecutor.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.documentdb.PartitionKeyDefinition;
import com.microsoft.azure.documentdb.Undefined;
import com.microsoft.azure.documentdb.bulkexecutor.internal.ExceptionUtils;
import com.microsoft.azure.documentdb.internal.routing.PartitionKeyInternal;
import java.util.Collections;
import java.util.Iterator;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentAnalyzer {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentAnalyzer.class);

    public static PartitionKeyInternal extractPartitionKeyValue(String documentAsString, PartitionKeyDefinition partitionKeyDefinition) {
        if (partitionKeyDefinition == null || partitionKeyDefinition.getPaths().size() == 0) {
            return PartitionKeyInternal.getEmpty();
        }
        return DocumentAnalyzer.extractPartitionKeyValueInternal(documentAsString, partitionKeyDefinition);
    }

    private static PartitionKeyInternal extractPartitionKeyValueInternal(String documentAsString, PartitionKeyDefinition partitionKeyDefinition) {
        try {
            Object partitionKeyValue;
            block11: {
                block10: {
                    JsonNode node;
                    JsonNode root = objectMapper.readTree(documentAsString);
                    Iterator path = partitionKeyDefinition.getPaths().iterator();
                    for (node = root.path(((String)path.next()).substring(1)); path.hasNext() && node != null; node = node.path((String)path.next())) {
                    }
                    partitionKeyValue = null;
                    if (node == null) break block10;
                    switch (node.getNodeType()) {
                        case BOOLEAN: {
                            partitionKeyValue = node.booleanValue();
                            break block11;
                        }
                        case MISSING: {
                            partitionKeyValue = Undefined.Value();
                            break block11;
                        }
                        case NULL: {
                            partitionKeyValue = JSONObject.NULL;
                            break block11;
                        }
                        case NUMBER: {
                            partitionKeyValue = node.numberValue();
                            break block11;
                        }
                        case STRING: {
                            partitionKeyValue = node.textValue();
                            break block11;
                        }
                        default: {
                            throw new RuntimeException(String.format("undefined json type %s", node.getNodeType()));
                        }
                    }
                }
                partitionKeyValue = Undefined.Value();
            }
            return DocumentAnalyzer.fromPartitionKeyvalue(partitionKeyValue);
        }
        catch (Exception e) {
            LOGGER.error("Failed to extract partition key value from document {}", (Object)documentAsString, (Object)e);
            throw ExceptionUtils.toRuntimeException(e);
        }
    }

    public static PartitionKeyInternal fromPartitionKeyvalue(Object partitionKeyValue) {
        try {
            return PartitionKeyInternal.fromObjectArray(Collections.singletonList(partitionKeyValue), (boolean)true);
        }
        catch (Exception e) {
            LOGGER.error("Failed to instantiate ParitionKeyInternal from {}", partitionKeyValue, (Object)e);
            throw ExceptionUtils.toRuntimeException(e);
        }
    }
}

