// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.

package com.microsoft.azure.javamsalruntime;

import com.sun.jna.ptr.LongByReference;

/**
 * Represents an MSALRUNTIME_ACCOUNT_HANDLE
 */
public class AccountHandle extends HandleBase {
    public AccountHandle() {
        super(MsalRuntimeInterop.MSALRUNTIME_LIBRARY::MSALRUNTIME_ReleaseAccount);
    }

    AccountHandle(LongByReference msalRuntimeHandle) {
        super(msalRuntimeHandle, MsalRuntimeInterop.MSALRUNTIME_LIBRARY::MSALRUNTIME_ReleaseAccount);
    }
}
