// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.

package com.microsoft.azure.javamsalruntime;

import com.sun.jna.ptr.LongByReference;

/**
 * Represents an MSALRUNTIME_ASYNC_HANDLE
 */
public class AsyncHandle extends HandleBase {
    public AsyncHandle() {
        super(MsalRuntimeInterop.MSALRUNTIME_LIBRARY::MSALRUNTIME_ReleaseAsyncHandle);
    }

    AsyncHandle(LongByReference msalRuntimeHandle) {
        super(msalRuntimeHandle,
              MsalRuntimeInterop.MSALRUNTIME_LIBRARY::MSALRUNTIME_ReleaseAsyncHandle);
    }
}
