// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.

package com.microsoft.azure.javamsalruntime;

import com.sun.jna.ptr.LongByReference;

/**
 * Represents an MSALRUNTIME_AUTH_PARAMETERS_HANDLE
 */
public class AuthParametersHandle extends HandleBase {
    public AuthParametersHandle() {
        super(MsalRuntimeInterop.MSALRUNTIME_LIBRARY::MSALRUNTIME_ReleaseAuthParameters);
    }

    AuthParametersHandle(LongByReference msalRuntimeHandle) {
        super(msalRuntimeHandle,
              MsalRuntimeInterop.MSALRUNTIME_LIBRARY::MSALRUNTIME_ReleaseAuthParameters);
    }
}
