// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.

package com.microsoft.azure.javamsalruntime;

/**
 * A simple class that can be used to create Exceptions with descriptive messages and our own error
 * codes <p> Follows the style of MSAl Java's exception classes, so that it can be easily converted
 * to an exception type that MSAL Java users already expect
 */
public class MsalInteropException extends RuntimeException {
    private final String errorMessage;
    private final String errorCode;

    /**
     * A catch-all constructor for exceptions that were caught but weren't expected
     */
    public MsalInteropException(final Throwable throwable) {
        super(throwable);

        this.errorMessage = throwable.getMessage();
        this.errorCode = "unexpected_exception";
    }

    /**
     * A constructor for exceptions that were caught, and we can provide a descriptive message
     * explaining the issue and how to resolve it
     */
    public MsalInteropException(final String errorMessage, String errorCode) {
        super(errorMessage);

        this.errorMessage = errorMessage;
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public String getErrorMessage() {
        return errorMessage;
    }
}
