// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.

package com.microsoft.azure.javamsalruntime;

/**
 * Values here match those in MSALRuntime's MSALRuntimeTypes.MSALRUNTIME_RESPONSE_STATUS enum
 * <p>
 * These values must be kept in sync with the values in MSALRuntime, to ensure proper error handling
 * and to create accurate error messages
 */
public enum MsalRuntimeResponseStatus {
    MSALRUNTIME_RESPONSE_STATUS_UNEXPECTED(0),
    MSALRUNTIME_RESPONSE_STATUS_RESERVED(1),
    MSALRUNTIME_RESPONSE_STATUS_INTERACTIONREQUIRED(2),
    MSALRUNTIME_RESPONSE_STATUS_NONETWORK(3),
    MSALRUNTIME_RESPONSE_STATUS_NETWORKTEMPORARILYUNAVAILABLE(4),
    MSALRUNTIME_RESPONSE_STATUS_SERVERTEMPORARILYUNAVAILABLE(5),
    MSALRUNTIME_RESPONSE_STATUS_APICONTRACTVIOLATION(6),
    MSALRUNTIME_RESPONSE_STATUS_USERCANCELED(7),
    MSALRUNTIME_RESPONSE_STATUS_APPLICATIONCANCELED(8),
    MSALRUNTIME_RESPONSE_STATUS_INCORRECTCONFIGURATION(9),
    MSALRUNTIME_RESPONSE_STATUS_INSUFFICIENTBUFFER(10),
    MSALRUNTIME_RESPONSE_STATUS_AUTHORITYUNTRUSTED(11),
    MSALRUNTIME_RESPONSE_STATUS_USERSWITCH(12),
    MSALRUNTIME_RESPONSE_STATUS_ACCOUNTUNUSABLE(13),
    MSALRUNTIME_RESPONSE_STATUS_USERDATAREMOVALREQUIRED(14),
    MSALRUNTIME_RESPONSE_STATUS_KEYNOTFOUND(15),
    MSALRUNTIME_RESPONSE_STATUS_ACCOUNTNOTFOUND(16);

    final int status;

    MsalRuntimeResponseStatus(int status) {
        this.status = status;
    }
}
