// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.

package com.microsoft.azure.javamsalruntime;

import com.sun.jna.ptr.LongByReference;

/**
 * Represents an single MSALRUNTIME_READ_ACCOUNT_RESULT_HANDLE
 */
public class ReadAccountResultHandle extends HandleBase {
    public ReadAccountResultHandle() {
        super(MsalRuntimeInterop.MSALRUNTIME_LIBRARY::MSALRUNTIME_ReleaseReadAccountResult);
    }

    ReadAccountResultHandle(LongByReference msalRuntimeHandle) {
        super(msalRuntimeHandle,
              MsalRuntimeInterop.MSALRUNTIME_LIBRARY::MSALRUNTIME_ReleaseReadAccountResult);
    }
}
