// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.

package com.microsoft.azure.javamsalruntime;

import com.sun.jna.ptr.LongByReference;

/**
 * Represents an MSALRUNTIME_SIGNOUT_RESULT_HANDLE
 */
public class SignOutResultHandle extends HandleBase {
    public SignOutResultHandle() {
        super(MsalRuntimeInterop.MSALRUNTIME_LIBRARY::MSALRUNTIME_ReleaseSignOutResult);
    }

    SignOutResultHandle(LongByReference msalRuntimeHandle) {
        super(msalRuntimeHandle,
              MsalRuntimeInterop.MSALRUNTIME_LIBRARY::MSALRUNTIME_ReleaseSignOutResult);
    }
}
