/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.javamsalruntime;

import com.microsoft.azure.javamsalruntime.ErrorHandle;
import com.microsoft.azure.javamsalruntime.HandleBase;
import com.microsoft.azure.javamsalruntime.MsalInteropException;
import com.microsoft.azure.javamsalruntime.MsalRuntimeInterop;
import com.microsoft.azure.javamsalruntime.MsalRuntimeResponseStatus;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Error {
    int msalRuntimeTag;
    long msalRuntimeErrorCode;
    MsalRuntimeResponseStatus msalRuntimeResponseStatus;
    String msalRuntimeContext;
    boolean isValidError = false;
    private static final Logger LOG = LoggerFactory.getLogger(Error.class);

    Error(ErrorHandle handle) {
        long msalRuntimeErrorHandle = handle.msalRuntimeHandle != null && handle.msalRuntimeHandle.getValue() != 0L ? handle.msalRuntimeHandle.getValue() : handle.getValue();
        if (msalRuntimeErrorHandle != 0L) {
            LOG.warn("MSALRuntime returned a non-zero MSALRUNTIME_ERROR_HANDLE.");
            this.isValidError = true;
            LOG.info("Parsing MSALRuntime error response.");
            this.msalRuntimeTag = Error.parseTag(msalRuntimeErrorHandle);
            this.msalRuntimeErrorCode = Error.parseErrorCode(msalRuntimeErrorHandle);
            this.msalRuntimeResponseStatus = Error.parseResponseStatus(msalRuntimeErrorHandle);
            this.msalRuntimeContext = Error.parseContext(handle);
        }
    }

    static int parseTag(long handle) {
        IntByReference tagRef = new IntByReference();
        Error.ignoreAndReleaseError(MsalRuntimeInterop.MSALRUNTIME_LIBRARY.MSALRUNTIME_GetTag(handle, tagRef));
        return tagRef.getValue();
    }

    static long parseErrorCode(long handle) {
        LongByReference errorCodeRef = new LongByReference();
        Error.ignoreAndReleaseError(MsalRuntimeInterop.MSALRUNTIME_LIBRARY.MSALRUNTIME_GetErrorCode(handle, errorCodeRef));
        return errorCodeRef.getValue();
    }

    static MsalRuntimeResponseStatus parseResponseStatus(long handle) {
        IntByReference responseStatusRef = new IntByReference();
        Error.ignoreAndReleaseError(MsalRuntimeInterop.MSALRUNTIME_LIBRARY.MSALRUNTIME_GetStatus(handle, responseStatusRef));
        try {
            return MsalRuntimeResponseStatus.values()[responseStatusRef.getValue()];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MsalInteropException("MSALRuntime returned an unknown or invalid response status: " + responseStatusRef.getValue(), "msalruntime_error");
        }
    }

    static String parseContext(LongByReference handle) {
        return HandleBase.getString(new ErrorHandle(handle), (error, context, bufferSize) -> MsalRuntimeInterop.MSALRUNTIME_LIBRARY.MSALRUNTIME_GetContext((ErrorHandle)error, context, bufferSize));
    }

    static void ignoreAndReleaseError(LongByReference errorHandle) {
        try (ErrorHandle handle = new ErrorHandle(errorHandle);){
            if (handle.isHandleValid()) {
                LOG.warn("Ignoring and releasing error without parsing.");
            }
        }
    }
}

