/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data;

import com.microsoft.azure.kusto.data.Ensure;
import com.microsoft.azure.kusto.data.Utils;
import com.microsoft.azure.kusto.data.format.CslBoolFormat;
import com.microsoft.azure.kusto.data.format.CslDateTimeFormat;
import com.microsoft.azure.kusto.data.format.CslIntFormat;
import com.microsoft.azure.kusto.data.format.CslLongFormat;
import com.microsoft.azure.kusto.data.format.CslRealFormat;
import com.microsoft.azure.kusto.data.format.CslTimespanFormat;
import com.microsoft.azure.kusto.data.format.CslUuidFormat;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.ParseException;
import org.json.JSONException;
import org.json.JSONObject;

public class ClientRequestProperties
implements Serializable {
    public static final String OPTION_SERVER_TIMEOUT = "servertimeout";
    public static final String OPTION_CLIENT_REQUEST_ID = "ClientRequestId";
    public static final Pattern KUSTO_TIMESPAN_REGEX = Pattern.compile("(-?)(?:(\\d+)(\\.))?(?:([0-2]?\\d)(:))?([0-5]?\\d)(:)([0-5]?\\d)(?:(\\.)(\\d+))?", 2);
    private static final String OPTIONS_KEY = "Options";
    private static final String PARAMETERS_KEY = "Parameters";
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private final Map<String, Object> options = new HashMap<String, Object>();
    static final long MAX_TIMEOUT_MS = TimeUnit.HOURS.toSeconds(1L) * 1000L;

    public void setOption(String name, Object value) {
        this.options.put(name, value);
    }

    public Object getOption(String name) {
        return this.options.get(name);
    }

    public void removeOption(String name) {
        this.options.remove(name);
    }

    public void clearOptions() {
        this.options.clear();
    }

    public void setParameter(String name, Object value) {
        this.parameters.put(name, value);
    }

    public void setParameter(String name, String value) {
        Ensure.stringIsNotBlank(name, "name");
        Ensure.argIsNotNull(value, "value");
        this.parameters.put(name, value);
    }

    public void setParameter(String name, Date value) {
        Ensure.stringIsNotBlank(name, "name");
        Ensure.argIsNotNull(value, "value");
        this.parameters.put(name, new CslDateTimeFormat(value).toString());
    }

    public void setParameter(String name, LocalDateTime value) {
        Ensure.stringIsNotBlank(name, "name");
        Ensure.argIsNotNull(value, "value");
        this.parameters.put(name, new CslDateTimeFormat(value).toString());
    }

    public void setParameter(String name, Duration value) {
        Ensure.stringIsNotBlank(name, "name");
        Ensure.argIsNotNull(value, "value");
        this.parameters.put(name, new CslTimespanFormat(value).toString());
    }

    public void setParameter(String name, boolean value) {
        Ensure.stringIsNotBlank(name, "name");
        this.parameters.put(name, new CslBoolFormat(value).toString());
    }

    public void setParameter(String name, int value) {
        Ensure.stringIsNotBlank(name, "name");
        this.parameters.put(name, new CslIntFormat(value).toString());
    }

    public void setParameter(String name, long value) {
        Ensure.stringIsNotBlank(name, "name");
        this.parameters.put(name, new CslLongFormat(value).toString());
    }

    public void setParameter(String name, double value) {
        Ensure.stringIsNotBlank(name, "name");
        this.parameters.put(name, new CslRealFormat(value).toString());
    }

    public void setParameter(String name, UUID value) {
        Ensure.stringIsNotBlank(name, "name");
        Ensure.argIsNotNull(value, "value");
        this.parameters.put(name, new CslUuidFormat(value).toString());
    }

    public Object getParameter(String name) {
        return this.parameters.get(name);
    }

    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public Long getTimeoutInMilliSec() {
        Object timeoutObj = this.getOption(OPTION_SERVER_TIMEOUT);
        Long timeout = null;
        if (timeoutObj instanceof Long) {
            timeout = (Long)timeoutObj;
        } else if (timeoutObj instanceof String) {
            timeout = this.parseTimeoutFromTimespanString((String)timeoutObj);
        } else if (timeoutObj instanceof Integer) {
            timeout = (long)((Integer)timeoutObj);
        }
        return timeout;
    }

    private long parseTimeoutFromTimespanString(String str) throws ParseException {
        Matcher matcher = KUSTO_TIMESPAN_REGEX.matcher(str);
        if (!matcher.matches()) {
            throw new ParseException(String.format("Failed to parse timeout string as a timespan. Value: '%s'", str));
        }
        if ("-".equals(matcher.group(1))) {
            throw new IllegalArgumentException(String.format("Negative timeouts are invalid. Value: '%s'", str));
        }
        long millis = 0L;
        String days = matcher.group(2);
        if (days != null && !days.equals("0")) {
            return MAX_TIMEOUT_MS;
        }
        String timespanWithoutDays = "";
        for (int i = 4; i <= 10; ++i) {
            if (matcher.group(i) == null) continue;
            timespanWithoutDays = timespanWithoutDays + matcher.group(i);
        }
        return millis += TimeUnit.NANOSECONDS.toMillis(LocalTime.parse(timespanWithoutDays).toNanoOfDay());
    }

    public void setTimeoutInMilliSec(Long timeoutInMs) {
        this.options.put(OPTION_SERVER_TIMEOUT, timeoutInMs);
    }

    JSONObject toJson() {
        try {
            JSONObject optionsAsJSON = new JSONObject(this.options);
            Object timeoutObj = this.getOption(OPTION_SERVER_TIMEOUT);
            if (timeoutObj != null) {
                String timeoutString = "";
                if (timeoutObj instanceof Long) {
                    Duration duration = Duration.ofMillis((Long)timeoutObj);
                    timeoutString = Utils.formatDurationAsTimespan(duration);
                } else if (timeoutObj instanceof String) {
                    timeoutString = (String)timeoutObj;
                } else if (timeoutObj instanceof Integer) {
                    Duration duration = Duration.ofMillis(((Integer)timeoutObj).intValue());
                    timeoutString = Utils.formatDurationAsTimespan(duration);
                }
                optionsAsJSON.put(OPTION_SERVER_TIMEOUT, (Object)timeoutString);
            }
            JSONObject json = new JSONObject();
            json.put(OPTIONS_KEY, (Object)optionsAsJSON);
            json.put(PARAMETERS_KEY, (Object)new JSONObject(this.parameters));
            return json;
        }
        catch (JSONException e) {
            return null;
        }
    }

    public String toString() {
        return this.toJson().toString();
    }

    public static ClientRequestProperties fromString(String json) throws JSONException {
        if (StringUtils.isNotBlank((CharSequence)json)) {
            ClientRequestProperties crp = new ClientRequestProperties();
            JSONObject jsonObj = new JSONObject(json);
            Iterator it = jsonObj.keys();
            while (it.hasNext()) {
                String propertyName = (String)it.next();
                if (propertyName.equals(OPTIONS_KEY)) {
                    JSONObject optionsJson = (JSONObject)jsonObj.get(propertyName);
                    Iterator optionsIt = optionsJson.keys();
                    while (optionsIt.hasNext()) {
                        String optionName = (String)optionsIt.next();
                        crp.setOption(optionName, optionsJson.get(optionName));
                    }
                    continue;
                }
                if (!propertyName.equals(PARAMETERS_KEY)) continue;
                JSONObject parameters = (JSONObject)jsonObj.get(propertyName);
                Iterator parametersIt = parameters.keys();
                while (parametersIt.hasNext()) {
                    String parameterName = (String)parametersIt.next();
                    crp.setParameter(parameterName, parameters.get(parameterName));
                }
            }
            return crp;
        }
        return null;
    }

    public String getClientRequestId() {
        return (String)this.getOption(OPTION_CLIENT_REQUEST_ID);
    }

    public void setClientRequestId(String clientRequestId) {
        this.setOption(OPTION_CLIENT_REQUEST_ID, clientRequestId);
    }

    Iterator<Map.Entry<String, Object>> getOptions() {
        return this.options.entrySet().iterator();
    }
}

