/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data;

import com.microsoft.azure.kusto.data.HttpClientProperties;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.http.HeaderElement;
import org.apache.http.HttpResponse;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientFactory.class);

    private HttpClientFactory() {
    }

    static HttpClientFactory getInstance() {
        return HttpClientFactorySingleton.instance;
    }

    CloseableHttpClient create(HttpClientProperties providedProperties) {
        HttpClientProperties properties = Optional.ofNullable(providedProperties).orElse(HttpClientProperties.builder().build());
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().useSystemProperties().setMaxConnTotal(properties.maxConnectionTotal().intValue()).setMaxConnPerRoute(properties.maxConnectionRoute().intValue()).evictExpiredConnections().evictIdleConnections((long)properties.maxIdleTime().intValue(), TimeUnit.SECONDS);
        if (properties.isKeepAlive()) {
            CustomConnectionKeepAliveStrategy keepAliveStrategy = new CustomConnectionKeepAliveStrategy(properties.maxKeepAliveTime());
            httpClientBuilder.setKeepAliveStrategy((ConnectionKeepAliveStrategy)keepAliveStrategy);
        }
        if (properties.getProxy() != null) {
            httpClientBuilder.setProxy(properties.getProxy());
        }
        CloseableHttpClient httpClient = httpClientBuilder.build();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> HttpClientFactory.closeClient(httpClient)));
        return httpClient;
    }

    private static void closeClient(CloseableHttpClient client) {
        try {
            LOGGER.info("Closing HTTP client");
            client.close();
        }
        catch (IOException e) {
            LOGGER.warn("Couldn't close HTTP client.");
        }
    }

    static class CustomConnectionKeepAliveStrategy
    implements ConnectionKeepAliveStrategy {
        private final int defaultKeepAlive;

        CustomConnectionKeepAliveStrategy(int defaultKeepAlive) {
            this.defaultKeepAlive = defaultKeepAlive;
        }

        public long getKeepAliveDuration(HttpResponse httpResponse, HttpContext httpContext) {
            BasicHeaderElementIterator it = new BasicHeaderElementIterator(httpResponse.headerIterator("Keep-Alive"));
            while (it.hasNext()) {
                HeaderElement he = it.nextElement();
                String param = he.getName();
                String value = he.getValue();
                if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                return Long.parseLong(value) * 1000L;
            }
            return (long)this.defaultKeepAlive * 1000L;
        }
    }

    private static class HttpClientFactorySingleton {
        private static final HttpClientFactory instance = new HttpClientFactory();

        private HttpClientFactorySingleton() {
        }
    }
}

