/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data;

import com.microsoft.azure.kusto.data.KustoResultSetTable;
import com.microsoft.azure.kusto.data.WellKnownDataSet;
import com.microsoft.azure.kusto.data.exceptions.KustoServiceQueryError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class KustoOperationResult
implements Iterator<KustoResultSetTable> {
    private static final Map<String, WellKnownDataSet> tablesKindsMap = new HashMap<String, WellKnownDataSet>(){
        {
            this.put("QueryResult", WellKnownDataSet.PrimaryResult);
            this.put("QueryProperties", WellKnownDataSet.QueryProperties);
            this.put("QueryStatus", WellKnownDataSet.QueryCompletionInformation);
        }
    };
    private static final String TABLE_NAME_PROPERTY_NAME = "Name";
    private static final String TABLE_ID_PROPERTY_NAME = "Id";
    private static final String TABLE_KIND_PROPERTY_NAME = "Kind";
    private static final String TABLES_LIST_PROPERTY_NAME = "Tables";
    private static final String DATA_TABLE_FRAME_TYPE_PROPERTY_NAME = "DataTable";
    private static final String FRAME_TYPE_PROPERTY_NAME = "FrameType";
    private final List<KustoResultSetTable> resultTables = new ArrayList<KustoResultSetTable>();
    private final Iterator<KustoResultSetTable> it;

    public KustoOperationResult(String response, String version) throws KustoServiceQueryError {
        if (version.contains("v2")) {
            this.createFromV2Response(response);
        } else {
            this.createFromV1Response(response);
        }
        this.it = this.resultTables.iterator();
    }

    public List<KustoResultSetTable> getResultTables() {
        return this.resultTables;
    }

    @Override
    public boolean hasNext() {
        return this.it.hasNext();
    }

    @Override
    public KustoResultSetTable next() {
        return this.it.next();
    }

    public KustoResultSetTable getPrimaryResults() {
        if (this.resultTables.size() == 1) {
            return this.resultTables.get(0);
        }
        return this.resultTables.stream().filter(t -> t.getTableKind().equals((Object)WellKnownDataSet.PrimaryResult)).findFirst().orElse(null);
    }

    private void createFromV1Response(String response) throws KustoServiceQueryError {
        JSONObject jsonObject = new JSONObject(response);
        JSONArray jsonArray = jsonObject.getJSONArray(TABLES_LIST_PROPERTY_NAME);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject table = jsonArray.getJSONObject(i);
            this.resultTables.add(new KustoResultSetTable(table));
        }
        if (this.resultTables.size() <= 2) {
            this.resultTables.get(0).setTableKind(WellKnownDataSet.PrimaryResult);
            this.resultTables.get(0).setTableId(Integer.toString(0));
            if (this.resultTables.size() == 2) {
                this.resultTables.get(1).setTableKind(WellKnownDataSet.QueryProperties);
                this.resultTables.get(1).setTableId(Integer.toString(1));
            }
        } else {
            KustoResultSetTable toc = this.resultTables.get(this.resultTables.size() - 1);
            toc.setTableKind(WellKnownDataSet.TableOfContents);
            toc.setTableId(Integer.toString(this.resultTables.size() - 1));
            for (int i = 0; i < this.resultTables.size() - 1; ++i) {
                toc.next();
                this.resultTables.get(i).setTableName(toc.getString(TABLE_NAME_PROPERTY_NAME));
                this.resultTables.get(i).setTableId(toc.getString(TABLE_ID_PROPERTY_NAME));
                this.resultTables.get(i).setTableKind(tablesKindsMap.get(toc.getString(TABLE_KIND_PROPERTY_NAME)));
            }
        }
    }

    private void createFromV2Response(String response) throws KustoServiceQueryError {
        JSONArray jsonArray = new JSONArray(response);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject table = jsonArray.getJSONObject(i);
            if (!table.optString(FRAME_TYPE_PROPERTY_NAME).equals(DATA_TABLE_FRAME_TYPE_PROPERTY_NAME)) continue;
            this.resultTables.add(new KustoResultSetTable(table));
        }
    }
}

