/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data;

import com.microsoft.azure.kusto.data.KustoResultColumn;
import com.microsoft.azure.kusto.data.WellKnownDataSet;
import com.microsoft.azure.kusto.data.exceptions.KustoServiceQueryError;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.json.JSONArray;
import org.json.JSONObject;

public class KustoResultSetTable {
    private static final String TABLE_NAME_PROPERTY_NAME = "TableName";
    private static final String TABLE_ID_PROPERTY_NAME = "TableId";
    private static final String TABLE_KIND_PROPERTY_NAME = "TableKind";
    private static final String COLUMNS_PROPERTY_NAME = "Columns";
    private static final String COLUMN_NAME_PROPERTY_NAME = "ColumnName";
    private static final String COLUMN_TYPE_PROPERTY_NAME = "ColumnType";
    private static final String COLUMN_TYPE_SECOND_PROPERTY_NAME = "DataType";
    private static final String ROWS_PROPERTY_NAME = "Rows";
    private static final String EXCEPTIONS_PROPERTY_NAME = "Exceptions";
    private static final String EXCEPTIONS_MESSAGE = "Query execution failed with multiple inner exceptions";
    private static DateTimeFormatter kustoDateTimeFormatter = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).appendLiteral('Z').toFormatter();
    private final List<List<Object>> rows;
    private String tableName;
    private String tableId;
    private WellKnownDataSet tableKind;
    private final Map<String, KustoResultColumn> columns = new HashMap<String, KustoResultColumn>();
    private KustoResultColumn[] columnsAsArray = null;
    private Iterator<List<Object>> rowIterator;
    private List<Object> currentRow = null;

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableId() {
        return this.tableId;
    }

    public WellKnownDataSet getTableKind() {
        return this.tableKind;
    }

    public KustoResultColumn[] getColumns() {
        return this.columnsAsArray;
    }

    void setTableId(String tableId) {
        this.tableId = tableId;
    }

    void setTableKind(WellKnownDataSet tableKind) {
        this.tableKind = tableKind;
    }

    protected KustoResultSetTable(JSONObject jsonTable) throws KustoServiceQueryError {
        JSONArray jsonRows;
        this.tableName = jsonTable.optString(TABLE_NAME_PROPERTY_NAME);
        this.tableId = jsonTable.optString(TABLE_ID_PROPERTY_NAME);
        String tableKindString = jsonTable.optString(TABLE_KIND_PROPERTY_NAME);
        this.tableKind = StringUtils.isBlank((CharSequence)tableKindString) ? null : WellKnownDataSet.valueOf(tableKindString);
        JSONArray columnsJson = jsonTable.optJSONArray(COLUMNS_PROPERTY_NAME);
        if (columnsJson != null) {
            this.columnsAsArray = new KustoResultColumn[columnsJson.length()];
            for (int i = 0; i < columnsJson.length(); ++i) {
                KustoResultColumn col;
                JSONObject jsonCol = columnsJson.getJSONObject(i);
                String columnType = jsonCol.optString(COLUMN_TYPE_PROPERTY_NAME);
                if (columnType.equals("")) {
                    columnType = jsonCol.optString(COLUMN_TYPE_SECOND_PROPERTY_NAME);
                }
                this.columnsAsArray[i] = col = new KustoResultColumn(jsonCol.getString(COLUMN_NAME_PROPERTY_NAME), columnType, i);
                this.columns.put(jsonCol.getString(COLUMN_NAME_PROPERTY_NAME), col);
            }
        }
        if ((jsonRows = jsonTable.optJSONArray(ROWS_PROPERTY_NAME)) != null) {
            ArrayList<List<Object>> values = new ArrayList<List<Object>>();
            for (int i = 0; i < jsonRows.length(); ++i) {
                Object row = jsonRows.get(i);
                if (row instanceof JSONObject) {
                    JSONArray exceptions = ((JSONObject)row).optJSONArray(EXCEPTIONS_PROPERTY_NAME);
                    if (exceptions != null) {
                        if (exceptions.length() == 1) {
                            String message = exceptions.getString(0);
                            throw new KustoServiceQueryError(message);
                        }
                        throw new KustoServiceQueryError(exceptions, false, EXCEPTIONS_MESSAGE);
                    }
                    throw new KustoServiceQueryError(((JSONObject)row).getJSONArray("OneApiErrors"), true, EXCEPTIONS_MESSAGE);
                }
                JSONArray rowAsJsonArray = jsonRows.getJSONArray(i);
                ArrayList<Object> rowVector = new ArrayList<Object>();
                for (int j = 0; j < rowAsJsonArray.length(); ++j) {
                    Object obj = rowAsJsonArray.get(j);
                    if (obj == JSONObject.NULL) {
                        rowVector.add(null);
                        continue;
                    }
                    rowVector.add(obj);
                }
                values.add(rowVector);
            }
            this.rows = values;
        } else {
            this.rows = new ArrayList<List<Object>>();
        }
        this.rowIterator = this.rows.iterator();
    }

    public List<Object> getCurrentRow() {
        return this.currentRow;
    }

    public boolean next() {
        boolean hasNext = this.rowIterator.hasNext();
        if (hasNext) {
            this.currentRow = this.rowIterator.next();
        }
        return hasNext;
    }

    public List<List<Object>> getData() {
        return this.rows;
    }

    private Object get(int columnIndex) {
        return this.currentRow.get(columnIndex);
    }

    private Object get(String colName) {
        return this.currentRow.get(this.findColumn(colName));
    }

    public String getString(int columnIndex) {
        return this.get(columnIndex).toString();
    }

    public boolean getBoolean(int columnIndex) {
        return (Boolean)this.get(columnIndex);
    }

    public Boolean getBooleanObject(int columnIndex) {
        return (Boolean)this.get(columnIndex);
    }

    public byte getByte(int columnIndex) {
        return (Byte)this.get(columnIndex);
    }

    public short getShort(int columnIndex) {
        Object obj = this.get(columnIndex);
        if (obj instanceof Integer) {
            return ((Integer)obj).shortValue();
        }
        return (Short)this.get(columnIndex);
    }

    public Short getShortObject(int columnIndex) {
        Object obj = this.get(columnIndex);
        if (obj == null) {
            return null;
        }
        return this.getShort(columnIndex);
    }

    public int getInt(int columnIndex) {
        return (Integer)this.get(columnIndex);
    }

    public Integer getIntegerObject(int columnIndex) {
        return (Integer)this.get(columnIndex);
    }

    public long getLong(int columnIndex) {
        Object obj = this.get(columnIndex);
        if (obj instanceof Integer) {
            return ((Integer)obj).longValue();
        }
        return (Long)obj;
    }

    public Long getLongObject(int columnIndex) {
        Object obj = this.get(columnIndex);
        if (obj instanceof Integer) {
            return ((Integer)obj).longValue();
        }
        return (Long)obj;
    }

    public float getFloat(int columnIndex) {
        return ((Float)this.get(columnIndex)).floatValue();
    }

    public Float getFloatObject(int columnIndex) {
        return (Float)this.get(columnIndex);
    }

    public double getDouble(int columnIndex) {
        return (Double)this.get(columnIndex);
    }

    public Double getDoubleObject(int columnIndex) {
        Object d = this.get(columnIndex);
        if (d instanceof BigDecimal) {
            return ((BigDecimal)d).doubleValue();
        }
        return (Double)this.get(columnIndex);
    }

    public byte[] getBytes(int columnIndex) {
        return (byte[])this.get(columnIndex);
    }

    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, Calendar.getInstance());
    }

    public Time getTime(int columnIndex) {
        LocalTime time = this.getLocalTime(columnIndex);
        if (time == null) {
            return null;
        }
        return Time.valueOf(this.getLocalTime(columnIndex));
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        switch (this.columnsAsArray[columnIndex].getColumnType()) {
            case "string": 
            case "datetime": {
                if (this.get(columnIndex) == null) {
                    return null;
                }
                return Timestamp.valueOf(StringUtils.chop((String)this.getString(columnIndex)).replace("T", " "));
            }
            case "long": 
            case "int": {
                Long l = this.getLongObject(columnIndex);
                if (l == null) {
                    return null;
                }
                return new Timestamp(l);
            }
        }
        throw new SQLException("Error parsing timestamp - expected string or long columns.");
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLFeatureNotSupportedException {
        if (this.columnsAsArray[columnIndex].getColumnType().equals("String")) {
            return new ByteArrayInputStream(this.getString(columnIndex).getBytes());
        }
        throw new SQLFeatureNotSupportedException("getBinaryStream is only available for strings");
    }

    public String getString(String columnName) {
        return this.get(columnName).toString();
    }

    public boolean getBoolean(String columnName) {
        return (Boolean)this.get(columnName);
    }

    public Boolean getBooleanObject(String columnName) {
        return (Boolean)this.get(columnName);
    }

    public byte getByte(String columnName) {
        return (Byte)this.get(columnName);
    }

    public short getShort(String columnName) {
        return this.getShort(this.findColumn(columnName));
    }

    public Short getShortObject(String columnName) {
        return this.getShortObject(this.findColumn(columnName));
    }

    public int getInt(String columnName) {
        return (Integer)this.get(columnName);
    }

    public Integer getIntegerObject(String columnName) {
        return this.getIntegerObject(this.findColumn(columnName));
    }

    public long getLong(String columnName) {
        return (Long)this.get(columnName);
    }

    public Long getLongObject(String columnName) {
        return this.getLongObject(this.findColumn(columnName));
    }

    public float getFloat(String columnName) {
        return ((Float)this.get(columnName)).floatValue();
    }

    public Float getFloatObject(String columnName) {
        return this.getFloatObject(this.findColumn(columnName));
    }

    public double getDouble(String columnName) {
        return (Double)this.get(columnName);
    }

    public Double getDoubleObject(String columnName) {
        return (Double)this.get(columnName);
    }

    public byte[] getBytes(String columnName) {
        return (byte[])this.get(columnName);
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public InputStream getAsciiStream(String columnName) {
        return (InputStream)this.get(columnName);
    }

    public InputStream getBinaryStream(String columnName) throws SQLFeatureNotSupportedException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    public Object getObject(int columnIndex) {
        return this.get(columnIndex);
    }

    public Object getObject(String columnName) {
        return this.get(columnName);
    }

    public JSONObject getJSONObject(String colName) {
        return this.getJSONObject(this.findColumn(colName));
    }

    public JSONObject getJSONObject(int columnIndex) {
        return (JSONObject)this.get(columnIndex);
    }

    public UUID getUUID(int columnIndex) {
        Object u = this.get(columnIndex);
        if (u == null) {
            return null;
        }
        return UUID.fromString((String)u);
    }

    public UUID getUUID(String columnName) {
        return this.getUUID(this.findColumn(columnName));
    }

    public int findColumn(String columnName) {
        return this.columns.get(columnName).getOrdinal();
    }

    public Reader getCharacterStream(int columnIndex) {
        return new StringReader(this.getString(columnIndex));
    }

    public Reader getCharacterStream(String columnName) {
        return new StringReader(this.getString(columnName));
    }

    public BigDecimal getBigDecimal(int columnIndex) {
        if (this.get(columnIndex) == null) {
            return null;
        }
        return new BigDecimal(this.getString(columnIndex));
    }

    public BigDecimal getBigDecimal(String columnName) {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public boolean isBeforeFirst() {
        return this.currentRow == null;
    }

    public boolean isAfterLast() {
        return this.currentRow == null && !this.rowIterator.hasNext();
    }

    public boolean isLast() {
        return this.currentRow != null && !this.rowIterator.hasNext();
    }

    public void beforeFirst() {
        this.rowIterator = this.rows.iterator();
    }

    public boolean first() {
        if (this.rows.isEmpty()) {
            return false;
        }
        this.rowIterator = this.rows.iterator();
        this.currentRow = this.rowIterator.next();
        return true;
    }

    public boolean last() {
        if (this.rows.isEmpty()) {
            return false;
        }
        while (this.rowIterator.next() != null) {
        }
        return true;
    }

    public boolean relative(int columnIndex) {
        return false;
    }

    public Array getArray(int columnIndex) {
        return (Array)this.get(columnIndex);
    }

    public Array getArray(String columnName) {
        return this.getArray(this.findColumn(columnName));
    }

    public LocalDateTime getKustoDateTime(int columnIndex) {
        if (this.get(columnIndex) == null) {
            return null;
        }
        String dateString = this.getString(columnIndex);
        return LocalDateTime.parse(dateString, kustoDateTimeFormatter);
    }

    public LocalDateTime getKustoDateTime(String columnName) {
        return this.getKustoDateTime(this.findColumn(columnName));
    }

    public Date getDate(int columnIndex, Calendar calendar) throws SQLException {
        if (calendar == null) {
            return this.getDate(columnIndex);
        }
        switch (this.columnsAsArray[columnIndex].getColumnType()) {
            case "string": 
            case "datetime": {
                try {
                    if (this.get(columnIndex) == null) {
                        return null;
                    }
                    String dateString = this.getString(columnIndex);
                    FastDateFormat dateFormat = dateString.length() < 21 ? FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss", (TimeZone)calendar.getTimeZone()) : FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSS", (TimeZone)calendar.getTimeZone());
                    return new Date(dateFormat.parse(dateString.substring(0, Math.min(dateString.length() - 1, 23))).getTime());
                }
                catch (Exception e) {
                    throw new SQLException("Error parsing Date", e);
                }
            }
            case "long": 
            case "int": {
                Long longVal = this.getLongObject(columnIndex);
                if (longVal == null) {
                    return null;
                }
                return new Date(longVal);
            }
        }
        throw new SQLException("Error parsing Date - expected string, long or datetime data type.");
    }

    public Date getDate(String columnName, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(int columnIndex, Calendar calendar) throws SQLException {
        return this.getTime(columnIndex);
    }

    public Time getTime(String columnName, Calendar calendar) throws SQLException {
        return this.getTime(columnName);
    }

    public LocalTime getLocalTime(int columnIndex) {
        Object time = this.get(columnIndex);
        if (time == null) {
            return null;
        }
        return LocalTime.parse((String)time);
    }

    public LocalTime getLocalTime(String columnName) {
        return this.getLocalTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(int columnIndex, Calendar calendar) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    public Timestamp getTimestamp(String columnName, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), calendar);
    }

    public URL getURL(int columnIndex) throws SQLException {
        try {
            return new URL(this.getString(columnIndex));
        }
        catch (MalformedURLException e) {
            throw new SQLException(e);
        }
    }

    public URL getURL(String columnName) throws SQLException {
        try {
            return new URL(this.getString(columnName));
        }
        catch (MalformedURLException e) {
            throw new SQLException(e);
        }
    }

    public int count() {
        return this.rows.size();
    }

    public boolean isNull(int columnIndex) {
        return this.get(columnIndex) == null;
    }
}

