/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data;

import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;

public class UriUtils {
    private UriUtils() {
    }

    public static String setPathForUri(String uri, String path, boolean ensureTrailingSlash) throws URISyntaxException {
        path = StringUtils.prependIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        String pathString = new URIBuilder(uri).setPath(path).build().toString();
        if (ensureTrailingSlash) {
            pathString = StringUtils.appendIfMissing((String)pathString, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        }
        return pathString;
    }

    public static String setPathForUri(String uri, String path) throws URISyntaxException {
        return UriUtils.setPathForUri(uri, path, false);
    }

    public static boolean isLocalAddress(String host) {
        if (host.equals("localhost") || host.equals("127.0.0.1") || host.equals("::1") || host.equals("[::1]")) {
            return true;
        }
        if (host.startsWith("127.") && host.length() <= 15 && host.length() >= 9) {
            for (int i = 0; i < host.length(); ++i) {
                char c = host.charAt(i);
                if (c == '.' || c >= '0' && c <= '9') continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

