/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data;

import com.microsoft.azure.kusto.data.CloseParentResourcesStream;
import com.microsoft.azure.kusto.data.UncloseableStream;
import com.microsoft.azure.kusto.data.exceptions.DataClientException;
import com.microsoft.azure.kusto.data.exceptions.DataServiceException;
import com.microsoft.azure.kusto.data.exceptions.DataWebException;
import com.microsoft.azure.kusto.data.exceptions.OneApiError;
import com.microsoft.azure.kusto.data.exceptions.ThrottleException;
import com.microsoft.azure.kusto.data.exceptions.WebException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.EofSensorInputStream;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Utils {
    private static final int MAX_REDIRECT_COUNT = 1;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private Utils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String post(CloseableHttpClient httpClient, String urlStr, String payload, InputStream stream, long timeoutMs, Map<String, String> headers, boolean leaveOpen) throws DataServiceException, DataClientException {
        URI url = Utils.parseUriFromUrlString(urlStr);
        try (InputStream ignored = stream != null && !leaveOpen ? stream : null;){
            HttpPost request = Utils.setupHttpPostRequest(url, payload, stream, headers);
            int requestTimeout = timeoutMs > Integer.MAX_VALUE ? Integer.MAX_VALUE : Math.toIntExact(timeoutMs);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(requestTimeout).build();
            request.setConfig(requestConfig);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
            HttpEntity entity = response.getEntity();
            if (entity == null) return null;
            StatusLine statusLine = response.getStatusLine();
            String responseContent = EntityUtils.toString((HttpEntity)entity);
            switch (statusLine.getStatusCode()) {
                case 200: {
                    String string = responseContent;
                    return string;
                }
                case 429: {
                    throw new ThrottleException(urlStr);
                }
            }
            throw Utils.createExceptionFromResponse(urlStr, (HttpResponse)response, null, responseContent);
        }
        catch (SocketTimeoutException e) {
            throw new DataServiceException(urlStr, "Timed out in post request:" + e.getMessage(), false);
        }
        catch (IOException | JSONException e) {
            throw new DataClientException(urlStr, "Error in post request:" + e.getMessage(), (Exception)e);
        }
    }

    static InputStream postToStreamingOutput(CloseableHttpClient httpClient, String url, String payload, long timeoutMs, Map<String, String> headers) throws DataServiceException, DataClientException {
        return Utils.postToStreamingOutput(httpClient, url, payload, timeoutMs, headers, 0);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static InputStream postToStreamingOutput(CloseableHttpClient httpClient, String url, String payload, long timeoutMs, Map<String, String> headers, int redirectCount) throws DataServiceException, DataClientException {
        CloseableHttpResponse httpResponse;
        String errorFromResponse;
        boolean returnInputStream;
        block11: {
            InputStream inputStream;
            int responseStatusCode;
            block8: {
                EofSensorInputStream contentStream;
                block9: {
                    Optional<Header> contentEncoding;
                    block10: {
                        long timeoutTimeMs = System.currentTimeMillis() + timeoutMs;
                        URI uri = Utils.parseUriFromUrlString(url);
                        returnInputStream = false;
                        errorFromResponse = null;
                        httpResponse = null;
                        HttpPost httpPost = Utils.setupHttpPostRequest(uri, payload, null, headers);
                        int requestTimeout = Math.toIntExact(timeoutTimeMs - System.currentTimeMillis());
                        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(requestTimeout).build();
                        httpPost.setConfig(requestConfig);
                        httpResponse = httpClient.execute((HttpUriRequest)httpPost);
                        responseStatusCode = httpResponse.getStatusLine().getStatusCode();
                        if (responseStatusCode != 200) break block8;
                        contentStream = new EofSensorInputStream((InputStream)new CloseParentResourcesStream(httpResponse), null);
                        contentEncoding = Arrays.stream(httpResponse.getHeaders("Content-Encoding")).findFirst();
                        if (!contentEncoding.isPresent()) break block9;
                        if (!contentEncoding.get().getValue().contains("gzip")) break block10;
                        GZIPInputStream gzipInputStream = new GZIPInputStream((InputStream)contentStream);
                        returnInputStream = true;
                        GZIPInputStream gZIPInputStream = gzipInputStream;
                        Utils.closeResourcesIfNeeded(returnInputStream, httpResponse);
                        return gZIPInputStream;
                    }
                    if (!contentEncoding.get().getValue().contains("deflate")) break block9;
                    DeflaterInputStream deflaterInputStream = new DeflaterInputStream((InputStream)contentStream);
                    returnInputStream = true;
                    DeflaterInputStream deflaterInputStream2 = deflaterInputStream;
                    Utils.closeResourcesIfNeeded(returnInputStream, httpResponse);
                    return deflaterInputStream2;
                }
                returnInputStream = true;
                EofSensorInputStream eofSensorInputStream = contentStream;
                Utils.closeResourcesIfNeeded(returnInputStream, httpResponse);
                return eofSensorInputStream;
            }
            try {
                Optional<Header> redirectLocation;
                errorFromResponse = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                httpResponse.close();
                if (!Utils.shouldPostToOriginalUrlDueToRedirect(redirectCount, responseStatusCode) || !(redirectLocation = Arrays.stream(httpResponse.getHeaders("Location")).findFirst()).isPresent() || redirectLocation.get().getValue().equals(url)) break block11;
                inputStream = Utils.postToStreamingOutput(httpClient, redirectLocation.get().getValue(), payload, timeoutMs, headers, redirectCount + 1);
            }
            catch (IOException ex) {
                try {
                    throw new DataServiceException(url, "postToStreamingOutput failed to get or decompress response stream", ex, false);
                    catch (Exception ex2) {
                        throw Utils.createExceptionFromResponse(url, httpResponse, ex2, errorFromResponse);
                    }
                }
                catch (Throwable throwable) {
                    Utils.closeResourcesIfNeeded(returnInputStream, httpResponse);
                    throw throwable;
                }
            }
            Utils.closeResourcesIfNeeded(returnInputStream, httpResponse);
            return inputStream;
        }
        Utils.closeResourcesIfNeeded(returnInputStream, httpResponse);
        throw Utils.createExceptionFromResponse(url, (HttpResponse)httpResponse, null, errorFromResponse);
    }

    static DataServiceException createExceptionFromResponse(String url, HttpResponse httpResponse, Exception thrownException, String errorFromResponse) {
        if (httpResponse == null) {
            return new DataServiceException(url, "POST failed to send request", thrownException, false);
        }
        String activityId = Utils.determineActivityId(httpResponse);
        String message = errorFromResponse;
        WebException formattedException = new WebException(errorFromResponse, httpResponse, thrownException);
        boolean isPermanent = false;
        if (!StringUtils.isBlank((CharSequence)errorFromResponse)) {
            try {
                JSONObject jsonObject = new JSONObject(errorFromResponse);
                if (jsonObject.has("error")) {
                    formattedException = new DataWebException(errorFromResponse, httpResponse, thrownException);
                    OneApiError apiError = ((DataWebException)formattedException).getApiError();
                    message = apiError.getDescription();
                    isPermanent = apiError.isPermanent();
                } else if (jsonObject.has("message")) {
                    message = jsonObject.getString("message");
                }
            }
            catch (JSONException jSONException) {}
        } else {
            message = String.format("Http StatusCode='%s'", httpResponse.getStatusLine().toString());
        }
        return new DataServiceException(url, String.format("%s, ActivityId='%s'", message, activityId), formattedException, isPermanent);
    }

    private static void closeResourcesIfNeeded(boolean returnInputStream, CloseableHttpResponse httpResponse) {
        if (!returnInputStream) {
            try {
                if (httpResponse != null) {
                    httpResponse.close();
                }
            }
            catch (IOException ex) {
                LOGGER.error("Couldn't close HttpResponse. This won't affect the POST call, but should be investigated.");
            }
        }
    }

    private static boolean shouldPostToOriginalUrlDueToRedirect(int redirectCount, int status) {
        return (status == 302 || status == 307) && redirectCount + 1 <= 1;
    }

    private static String determineActivityId(HttpResponse httpResponse) {
        String activityId = "";
        Optional<Header> activityIdHeader = Arrays.stream(httpResponse.getHeaders("x-ms-activity-id")).findFirst();
        if (activityIdHeader.isPresent()) {
            activityId = activityIdHeader.get().getValue();
        }
        return activityId;
    }

    private static HttpPost setupHttpPostRequest(URI uri, String payload, InputStream stream, Map<String, String> headers) {
        HttpPost request = new HttpPost(uri);
        StringEntity requestEntity = stream == null ? new StringEntity(payload, ContentType.APPLICATION_JSON) : new InputStreamEntity((InputStream)new UncloseableStream(stream));
        request.setEntity((HttpEntity)requestEntity);
        request.addHeader("Accept-Encoding", "gzip,deflate");
        request.addHeader("Accept", "application/json");
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            request.addHeader(entry.getKey(), entry.getValue());
        }
        return request;
    }

    @NotNull
    private static URI parseUriFromUrlString(String url) throws DataClientException {
        try {
            URL cleanUrl = new URL(url);
            if ("https".equalsIgnoreCase(cleanUrl.getProtocol()) || url.toLowerCase().startsWith("http://localhost")) {
                return new URI(cleanUrl.getProtocol(), cleanUrl.getUserInfo(), cleanUrl.getHost(), cleanUrl.getPort(), cleanUrl.getPath(), cleanUrl.getQuery(), cleanUrl.getRef());
            }
            throw new DataClientException(url, "Cannot forward security token to a remote service over insecure channel (http://)");
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new DataClientException(url, "Error parsing target URL in post request:" + e.getMessage(), e);
        }
    }

    static String getPackageVersion() {
        String string;
        block8: {
            Properties props = new Properties();
            InputStream versionFileStream = Utils.class.getResourceAsStream("/app.properties");
            try {
                props.load(versionFileStream);
                string = props.getProperty("version").trim();
                if (versionFileStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (versionFileStream != null) {
                        try {
                            versionFileStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return "";
                }
            }
            versionFileStream.close();
        }
        return string;
    }

    public static String formatDurationAsTimespan(Duration duration) {
        long seconds = duration.getSeconds();
        int nanos = duration.getNano();
        long hours = TimeUnit.SECONDS.toHours(seconds) % TimeUnit.DAYS.toHours(1L);
        long minutes = TimeUnit.SECONDS.toMinutes(seconds) % TimeUnit.MINUTES.toSeconds(1L);
        long secs = seconds % TimeUnit.HOURS.toSeconds(1L);
        long days = TimeUnit.SECONDS.toDays(seconds);
        String positive = String.format("%02d.%02d:%02d:%02d.%.3s", days, hours, minutes, secs, nanos);
        return seconds < 0L ? "-" + positive : positive;
    }
}

