/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.auth;

import com.microsoft.azure.kusto.data.auth.CloudInfo;
import com.microsoft.azure.kusto.data.auth.TokenProviderBase;
import com.microsoft.azure.kusto.data.exceptions.DataClientException;
import com.microsoft.azure.kusto.data.exceptions.DataServiceException;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import org.apache.http.client.HttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CloudDependentTokenProviderBase
extends TokenProviderBase {
    private static final String ERROR_INVALID_SERVICE_RESOURCE_URL = "Error determining scope due to invalid Kusto Service Resource URL";
    protected final Set<String> scopes = new HashSet<String>();
    private boolean initialized = false;

    CloudDependentTokenProviderBase(@NotNull String clusterUrl, @Nullable HttpClient httpClient) throws URISyntaxException {
        super(clusterUrl, httpClient);
    }

    synchronized void initialize() throws DataClientException, DataServiceException {
        if (this.initialized) {
            return;
        }
        this.initializeWithCloudInfo(CloudInfo.retrieveCloudInfoForCluster(this.clusterUrl, this.httpClient));
        this.initialized = true;
    }

    protected void initializeWithCloudInfo(CloudInfo cloudInfo) throws DataClientException, DataServiceException {
        try {
            this.scopes.add(cloudInfo.determineScope());
        }
        catch (URISyntaxException e) {
            throw new DataServiceException(this.clusterUrl, ERROR_INVALID_SERVICE_RESOURCE_URL, e, true);
        }
    }

    @Override
    public String acquireAccessToken() throws DataServiceException, DataClientException {
        this.initialize();
        return this.acquireAccessTokenImpl();
    }

    protected abstract String acquireAccessTokenImpl() throws DataServiceException, DataClientException;
}

