/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.auth;

import com.microsoft.azure.kusto.data.UriUtils;
import com.microsoft.azure.kusto.data.exceptions.DataServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

public class CloudInfo {
    private static final Map<String, CloudInfo> cache = new HashMap<String, CloudInfo>();
    public static final String METADATA_ENDPOINT = "v1/rest/auth/metadata";
    public static final String DEFAULT_KUSTO_CLIENT_APP_ID = "db662dc1-0cfe-4e1c-a843-19a68e65be58";
    public static final boolean DEFAULT_LOGIN_MFA_REQUIRED = false;
    public static final String DEFAULT_PUBLIC_LOGIN_URL = "https://login.microsoftonline.com";
    public static final String DEFAULT_REDIRECT_URI = "https://microsoft/kustoclient";
    public static final String DEFAULT_KUSTO_SERVICE_RESOURCE_ID = "https://kusto.kusto.windows.net";
    public static final String DEFAULT_FIRST_PARTY_AUTHORITY_URL = "https://login.microsoftonline.com/f8cdef31-a31e-4b4a-93e4-5f571e91255a";
    public static final CloudInfo DEFAULT_CLOUD = new CloudInfo(false, "https://login.microsoftonline.com", "db662dc1-0cfe-4e1c-a843-19a68e65be58", "https://microsoft/kustoclient", "https://kusto.kusto.windows.net", "https://login.microsoftonline.com/f8cdef31-a31e-4b4a-93e4-5f571e91255a");
    public static final String LOCALHOST = "http://localhost";
    private final boolean loginMfaRequired;
    private final String loginEndpoint;
    private final String kustoClientAppId;
    private final String kustoClientRedirectUri;
    private final String kustoServiceResourceId;
    private final String firstPartyAuthorityUrl;

    public CloudInfo(boolean loginMfaRequired, String loginEndpoint, String kustoClientAppId, String kustoClientRedirectUri, String kustoServiceResourceId, String firstPartyAuthorityUrl) {
        this.loginMfaRequired = loginMfaRequired;
        this.loginEndpoint = loginEndpoint;
        this.kustoClientAppId = kustoClientAppId;
        this.kustoClientRedirectUri = kustoClientRedirectUri;
        this.kustoServiceResourceId = kustoServiceResourceId;
        this.firstPartyAuthorityUrl = firstPartyAuthorityUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void manuallyAddToCache(String clusterUrl, CloudInfo cloudInfo) throws URISyntaxException {
        Map<String, CloudInfo> map = cache;
        synchronized (map) {
            cache.put(UriUtils.setPathForUri(clusterUrl, ""), cloudInfo);
        }
    }

    public static CloudInfo retrieveCloudInfoForCluster(String clusterUrl) throws DataServiceException {
        return CloudInfo.retrieveCloudInfoForCluster(clusterUrl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloudInfo retrieveCloudInfoForCluster(String clusterUrl, @Nullable HttpClient givenHttpClient) throws DataServiceException {
        Map<String, CloudInfo> map = cache;
        synchronized (map) {
            CloudInfo result;
            block19: {
                CloudInfo cloudInfo;
                try {
                    cloudInfo = cache.get(UriUtils.setPathForUri(clusterUrl, ""));
                }
                catch (URISyntaxException ex) {
                    throw new DataServiceException(clusterUrl, "Error in metadata endpoint, cluster uri invalid", ex, true);
                }
                if (cloudInfo != null) {
                    return cloudInfo;
                }
                try {
                    CloseableHttpClient localHttpClient = givenHttpClient == null ? HttpClients.createSystem() : givenHttpClient;
                    try {
                        HttpGet request = new HttpGet(UriUtils.setPathForUri(clusterUrl, METADATA_ENDPOINT));
                        request.addHeader("Accept-Encoding", "gzip,deflate");
                        request.addHeader("Accept", "application/json");
                        HttpResponse response = localHttpClient.execute((HttpUriRequest)request);
                        try {
                            int statusCode = response.getStatusLine().getStatusCode();
                            if (statusCode == 200) {
                                String content = EntityUtils.toString((HttpEntity)response.getEntity());
                                if (content == null || content.equals("") || content.equals("{}")) {
                                    throw new DataServiceException(clusterUrl, "Error in metadata endpoint, received no data", true);
                                }
                                result = CloudInfo.parseCloudInfo(content);
                                break block19;
                            }
                            if (statusCode == 404) {
                                result = DEFAULT_CLOUD;
                                break block19;
                            }
                            String errorFromResponse = EntityUtils.toString((HttpEntity)response.getEntity());
                            throw new DataServiceException(clusterUrl, "Error in metadata endpoint, got code: " + statusCode + "\nWith error: " + errorFromResponse, true);
                        }
                        finally {
                            if (response instanceof Closeable) {
                                ((Closeable)response).close();
                            }
                        }
                    }
                    finally {
                        if (givenHttpClient == null && localHttpClient != null) {
                            ((Closeable)localHttpClient).close();
                        }
                    }
                }
                catch (IOException | URISyntaxException ex) {
                    throw new DataServiceException(clusterUrl, "IOError when trying to retrieve CloudInfo", ex, true);
                }
            }
            cache.put(clusterUrl, result);
            return result;
        }
    }

    private static CloudInfo parseCloudInfo(String content) {
        JSONObject jsonObject = new JSONObject(content);
        JSONObject innerObject = jsonObject.optJSONObject("AzureAD");
        if (innerObject == null) {
            return DEFAULT_CLOUD;
        }
        return new CloudInfo(innerObject.getBoolean("LoginMfaRequired"), innerObject.getString("LoginEndpoint"), innerObject.getString("KustoClientAppId"), innerObject.getString("KustoClientRedirectUri"), innerObject.getString("KustoServiceResourceId"), innerObject.getString("FirstPartyAuthorityUrl"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudInfo cloudInfo = (CloudInfo)o;
        return this.loginMfaRequired == cloudInfo.loginMfaRequired && Objects.equals(this.loginEndpoint, cloudInfo.loginEndpoint) && Objects.equals(this.kustoClientAppId, cloudInfo.kustoClientAppId) && Objects.equals(this.kustoClientRedirectUri, cloudInfo.kustoClientRedirectUri) && Objects.equals(this.kustoServiceResourceId, cloudInfo.kustoServiceResourceId) && Objects.equals(this.firstPartyAuthorityUrl, cloudInfo.firstPartyAuthorityUrl);
    }

    public int hashCode() {
        return Objects.hash(this.loginMfaRequired, this.loginEndpoint, this.kustoClientAppId, this.kustoClientRedirectUri, this.kustoServiceResourceId, this.firstPartyAuthorityUrl);
    }

    public boolean isLoginMfaRequired() {
        return this.loginMfaRequired;
    }

    public String getLoginEndpoint() {
        return this.loginEndpoint;
    }

    public String getKustoClientAppId() {
        return this.kustoClientAppId;
    }

    public String getKustoClientRedirectUri() {
        return this.kustoClientRedirectUri;
    }

    public String getKustoServiceResourceId() {
        return this.kustoServiceResourceId;
    }

    public String getFirstPartyAuthorityUrl() {
        return this.firstPartyAuthorityUrl;
    }

    public String determineScope() throws URISyntaxException {
        String resourceUrl = this.getKustoServiceResourceId();
        if (this.isLoginMfaRequired()) {
            resourceUrl = resourceUrl.replace(".kusto.", ".kustomfa.");
        }
        resourceUrl = StringUtils.appendIfMissing((String)resourceUrl, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        return resourceUrl + ".default";
    }

    static {
        cache.put(LOCALHOST, DEFAULT_CLOUD);
    }
}

