/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.auth;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpRequest;
import com.microsoft.aad.msal4j.IHttpClient;
import com.microsoft.aad.msal4j.IHttpResponse;
import com.microsoft.azure.kusto.data.auth.HttpResponseWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.message.BasicHeader;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class HttpClientWrapper
implements HttpClient,
IHttpClient {
    private final org.apache.http.client.HttpClient httpClient;

    HttpClientWrapper(org.apache.http.client.HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public Mono<com.azure.core.http.HttpResponse> send(HttpRequest httpRequest) {
        HttpGet request;
        String uri = httpRequest.getUrl().toString();
        switch (httpRequest.getHttpMethod()) {
            case GET: {
                request = new HttpGet(uri);
                break;
            }
            case POST: {
                request = new HttpPost(uri);
                break;
            }
            case PUT: {
                request = new HttpPut(uri);
                break;
            }
            case PATCH: {
                request = new HttpPatch(uri);
                break;
            }
            case DELETE: {
                request = new HttpDelete(uri);
                break;
            }
            case HEAD: {
                request = new HttpHead(uri);
                break;
            }
            case OPTIONS: {
                request = new HttpOptions(uri);
                break;
            }
            case TRACE: {
                request = new HttpTrace(uri);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported HTTP method: " + httpRequest.getHttpMethod());
            }
        }
        request.setHeaders((Header[])httpRequest.getHeaders().stream().map(h -> new BasicHeader(h.getName(), h.getValue())).toArray(Header[]::new));
        Mono before = Mono.empty();
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest entityEnclosingRequest = (HttpEntityEnclosingRequest)request;
            PipedOutputStream osPipe = new PipedOutputStream();
            PipedInputStream isPipe = null;
            try {
                isPipe = new PipedInputStream(osPipe);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            before = Mono.from((Publisher)httpRequest.getBody().map(buf -> {
                try {
                    osPipe.write(buf.array());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return buf;
            }));
            entityEnclosingRequest.setEntity((HttpEntity)new InputStreamEntity((InputStream)isPipe));
        }
        return before.flatMap(arg_0 -> this.lambda$send$4((HttpUriRequest)request, httpRequest, arg_0));
    }

    public IHttpResponse send(com.microsoft.aad.msal4j.HttpRequest httpRequest) throws Exception {
        HttpGet request;
        String uri = httpRequest.url().toString();
        switch (httpRequest.httpMethod()) {
            case GET: {
                request = new HttpGet(uri);
                break;
            }
            case POST: {
                request = new HttpPost(uri);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported HTTP method: " + httpRequest.httpMethod());
            }
        }
        request.setHeaders((Header[])httpRequest.headers().entrySet().stream().map(h -> new BasicHeader((String)h.getKey(), (String)h.getValue())).toArray(Header[]::new));
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest entityEnclosingRequest = (HttpEntityEnclosingRequest)request;
            String body = httpRequest.body();
            entityEnclosingRequest.setEntity((HttpEntity)new ByteArrayEntity(body.getBytes(StandardCharsets.UTF_8)));
        }
        return new HttpResponseWrapper(this.httpClient.execute((HttpUriRequest)request));
    }

    private /* synthetic */ Object lambda$send$4(HttpUriRequest request, HttpRequest httpRequest, Object a) {
        return Mono.create(monoSink -> {
            try {
                HttpResponse response = this.httpClient.execute(request);
                monoSink.success((Object)new HttpResponseWrapper(httpRequest, response));
            }
            catch (IOException e) {
                monoSink.error((Throwable)e);
            }
        });
    }
}

