/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.auth;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.microsoft.aad.msal4j.IHttpResponse;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class HttpResponseWrapper
extends HttpResponse
implements IHttpResponse {
    org.apache.http.HttpResponse response;
    private byte[] body = null;

    protected HttpResponseWrapper(HttpRequest request, org.apache.http.HttpResponse response) {
        super(request);
        this.response = response;
    }

    protected HttpResponseWrapper(org.apache.http.HttpResponse response) {
        this(null, response);
    }

    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    public String getHeaderValue(String s) {
        return this.response.getFirstHeader(s).getValue();
    }

    public HttpHeaders getHeaders() {
        Header[] allHeaders;
        HashMap newHeaders = new HashMap();
        for (Header header : allHeaders = this.response.getAllHeaders()) {
            if (newHeaders.containsKey(header.getName())) {
                ((List)newHeaders.get(header.getName())).add(header.getValue());
                continue;
            }
            ArrayList<String> values = new ArrayList<String>();
            values.add(header.getValue());
            newHeaders.put(header.getName(), values);
        }
        return new HttpHeaders((Iterable)newHeaders.entrySet().stream().map(e -> new HttpHeader((String)e.getKey(), (List)e.getValue())).collect(Collectors.toList()));
    }

    public Flux<ByteBuffer> getBody() {
        return this.getBodyAsByteArray().map(ByteBuffer::wrap).flux();
    }

    public Mono<byte[]> getBodyAsByteArray() {
        if (this.body == null) {
            try {
                this.body = EntityUtils.toByteArray((HttpEntity)this.response.getEntity());
            }
            catch (IOException ignored) {
                this.body = new byte[0];
            }
        }
        return Mono.just((Object)this.body);
    }

    public Mono<String> getBodyAsString() {
        return this.getBodyAsByteArray().map(String::new);
    }

    public Mono<String> getBodyAsString(Charset charset) {
        return this.getBodyAsByteArray().map(bytes -> new String((byte[])bytes, charset));
    }

    public int statusCode() {
        return this.getStatusCode();
    }

    public Map<String, List<String>> headers() {
        return this.getHeaders().stream().collect(Collectors.toMap(com.azure.core.util.Header::getName, com.azure.core.util.Header::getValuesList));
    }

    public String body() {
        String block = (String)this.getBodyAsString().block();
        return block;
    }
}

