/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.auth;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.http.HttpClient;
import com.azure.identity.ManagedIdentityCredential;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.microsoft.azure.kusto.data.auth.CloudDependentTokenProviderBase;
import com.microsoft.azure.kusto.data.auth.CloudInfo;
import com.microsoft.azure.kusto.data.auth.HttpClientWrapper;
import com.microsoft.azure.kusto.data.exceptions.DataClientException;
import com.microsoft.azure.kusto.data.exceptions.DataServiceException;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManagedIdentityTokenProvider
extends CloudDependentTokenProviderBase {
    private final String managedIdentityClientId;
    private ManagedIdentityCredential managedIdentityCredential;
    private TokenRequestContext tokenRequestContext;

    public ManagedIdentityTokenProvider(@NotNull String clusterUrl, String managedIdentityClientId, @Nullable org.apache.http.client.HttpClient httpClient) throws URISyntaxException {
        super(clusterUrl, httpClient);
        this.managedIdentityClientId = managedIdentityClientId;
    }

    @Override
    protected void initializeWithCloudInfo(CloudInfo cloudInfo) throws DataServiceException, DataClientException {
        super.initializeWithCloudInfo(cloudInfo);
        ManagedIdentityCredentialBuilder builder = new ManagedIdentityCredentialBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.managedIdentityClientId)) {
            builder = builder.clientId(this.managedIdentityClientId);
        }
        if (this.httpClient != null) {
            builder = (ManagedIdentityCredentialBuilder)builder.httpClient((HttpClient)new HttpClientWrapper(this.httpClient));
        }
        this.managedIdentityCredential = builder.build();
        this.tokenRequestContext = new TokenRequestContext().addScopes(this.scopes.toArray(new String[0]));
    }

    @Override
    public String acquireAccessTokenImpl() throws DataServiceException {
        AccessToken accessToken = (AccessToken)this.managedIdentityCredential.getToken(this.tokenRequestContext).block();
        if (accessToken == null) {
            throw new DataServiceException(this.clusterUrl, "Couldn't get token from Azure Identity", true);
        }
        return accessToken.getToken();
    }
}

