/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.exceptions;

import com.microsoft.azure.kusto.data.exceptions.DataWebException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

public class KustoServiceQueryError
extends Exception {
    private final List<Exception> exceptions = new ArrayList<Exception>();

    public KustoServiceQueryError(JSONArray jsonExceptions, boolean isOneApi, String message) throws JSONException {
        super(message);
        for (int j = 0; j < jsonExceptions.length(); ++j) {
            if (isOneApi) {
                this.exceptions.add(new DataWebException(jsonExceptions.getJSONObject(j).toString()));
                continue;
            }
            this.exceptions.add(new Exception(jsonExceptions.getString(j)));
        }
    }

    public KustoServiceQueryError(String message) {
        super(message);
        this.exceptions.add(new Exception(message));
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    @Override
    public String toString() {
        return this.exceptions.isEmpty() ? this.getMessage() : "exceptions\":" + this.exceptions + "}";
    }

    public boolean isPermanent() {
        if (this.exceptions.size() > 0 && this.exceptions.get(0) instanceof DataWebException) {
            return ((DataWebException)this.exceptions.get(0)).getApiError().isPermanent();
        }
        return false;
    }
}

