/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.auth;

import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IHttpClient;
import com.microsoft.aad.msal4j.IPublicClientApplication;
import com.microsoft.aad.msal4j.PublicClientApplication;
import com.microsoft.azure.kusto.data.auth.CloudInfo;
import com.microsoft.azure.kusto.data.auth.HttpClientWrapper;
import com.microsoft.azure.kusto.data.auth.MsalTokenProviderBase;
import com.microsoft.azure.kusto.data.exceptions.DataClientException;
import com.microsoft.azure.kusto.data.exceptions.DataServiceException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.client.HttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PublicAppTokenProviderBase
extends MsalTokenProviderBase {
    protected IPublicClientApplication clientApplication;
    protected String clientAppId;

    PublicAppTokenProviderBase(@NotNull String clusterUrl, String authorityId, @Nullable HttpClient httpClient) throws URISyntaxException {
        super(clusterUrl, authorityId, httpClient);
    }

    @Override
    protected void initializeWithCloudInfo(CloudInfo cloudInfo) throws DataClientException, DataServiceException {
        super.initializeWithCloudInfo(cloudInfo);
        try {
            this.clientAppId = cloudInfo.getKustoClientAppId();
            PublicClientApplication.Builder authority = (PublicClientApplication.Builder)PublicClientApplication.builder((String)this.clientAppId).authority(this.aadAuthorityUrl);
            if (this.httpClient != null) {
                authority.httpClient((IHttpClient)new HttpClientWrapper(this.httpClient));
            }
            this.clientApplication = authority.build();
        }
        catch (MalformedURLException e) {
            throw new DataClientException(this.clusterUrl, "Error acquiring ApplicationAccessToken due to invalid Authority URL", e);
        }
    }

    @Override
    protected IAuthenticationResult acquireAccessTokenSilentlyMsal() throws MalformedURLException, InterruptedException, ExecutionException, TimeoutException {
        CompletableFuture accounts = this.clientApplication.getAccounts();
        return (IAuthenticationResult)this.clientApplication.acquireTokenSilently(this.getSilentParameters((Set)accounts.join())).get(20000L, TimeUnit.MILLISECONDS);
    }
}

