/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.microsoft.azure.kusto.data.Client;
import com.microsoft.azure.kusto.data.ClientDetails;
import com.microsoft.azure.kusto.data.ClientRequestProperties;
import com.microsoft.azure.kusto.data.CommandType;
import com.microsoft.azure.kusto.data.HttpClientProperties;
import com.microsoft.azure.kusto.data.IngestionSourceStorage;
import com.microsoft.azure.kusto.data.KustoOperationResult;
import com.microsoft.azure.kusto.data.StreamingClient;
import com.microsoft.azure.kusto.data.Utils;
import com.microsoft.azure.kusto.data.auth.CloudInfo;
import com.microsoft.azure.kusto.data.auth.ConnectionStringBuilder;
import com.microsoft.azure.kusto.data.auth.TokenProviderBase;
import com.microsoft.azure.kusto.data.auth.TokenProviderFactory;
import com.microsoft.azure.kusto.data.auth.endpoints.KustoTrustedEndpoints;
import com.microsoft.azure.kusto.data.exceptions.DataClientException;
import com.microsoft.azure.kusto.data.exceptions.DataServiceException;
import com.microsoft.azure.kusto.data.exceptions.KustoClientInvalidConnectionStringException;
import com.microsoft.azure.kusto.data.exceptions.KustoServiceQueryError;
import com.microsoft.azure.kusto.data.http.HttpClientFactory;
import com.microsoft.azure.kusto.data.http.HttpPostUtils;
import com.microsoft.azure.kusto.data.http.UncloseableStream;
import com.microsoft.azure.kusto.data.instrumentation.MonitoredActivity;
import com.microsoft.azure.kusto.data.instrumentation.TraceableAttributes;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.jetbrains.annotations.NotNull;

class ClientImpl
implements Client,
StreamingClient {
    private static final String ADMIN_COMMANDS_PREFIX = ".";
    public static final String MGMT_ENDPOINT_VERSION = "v1";
    public static final String QUERY_ENDPOINT_VERSION = "v2";
    public static final String STREAMING_VERSION = "v1";
    private static final String DEFAULT_DATABASE_NAME = "NetDefaultDb";
    private static final Long COMMAND_TIMEOUT_IN_MILLISECS = TimeUnit.MINUTES.toMillis(10L);
    private static final Long QUERY_TIMEOUT_IN_MILLISECS = TimeUnit.MINUTES.toMillis(4L);
    private static final Long STREAMING_INGEST_TIMEOUT_IN_MILLISECS = TimeUnit.MINUTES.toMillis(10L);
    private static final int CLIENT_SERVER_DELTA_IN_MILLISECS = (int)TimeUnit.SECONDS.toMillis(30L);
    public static final String CLIENT_VERSION_HEADER = "x-ms-client-version";
    public static final String APP_HEADER = "x-ms-app";
    public static final String USER_HEADER = "x-ms-user";
    public static final String FEDERATED_SECURITY_SUFFIX = ";fed=true";
    public static final String JAVA_INGEST_ACTIVITY_TYPE_PREFIX = "DN.JavaClient.Execute";
    private final TokenProviderBase aadAuthenticationHelper;
    private final String clusterUrl;
    private final ClientDetails clientDetails;
    private final CloseableHttpClient httpClient;
    private final boolean leaveHttpClientOpen;
    private boolean endpointValidated = false;
    private final ObjectMapper objectMapper = Utils.getObjectMapper();

    public ClientImpl(ConnectionStringBuilder csb) throws URISyntaxException {
        this(csb, HttpClientProperties.builder().build());
    }

    public ClientImpl(ConnectionStringBuilder csb, HttpClientProperties properties) throws URISyntaxException {
        this(csb, HttpClientFactory.create(properties), false);
    }

    public ClientImpl(ConnectionStringBuilder csb, CloseableHttpClient httpClient, boolean leaveHttpClientOpen) throws URISyntaxException {
        URI clusterUrlForParsing = new URI(csb.getClusterUrl());
        String host = clusterUrlForParsing.getHost();
        Objects.requireNonNull(clusterUrlForParsing.getAuthority(), "clusterUri must have uri authority component");
        String auth = clusterUrlForParsing.getAuthority().toLowerCase();
        if (host == null) {
            host = StringUtils.removeEndIgnoreCase((String)auth, (String)FEDERATED_SECURITY_SUFFIX);
        }
        URIBuilder uriBuilder = new URIBuilder().setScheme(clusterUrlForParsing.getScheme()).setHost(host);
        String path = clusterUrlForParsing.getPath();
        if (path != null && !path.isEmpty()) {
            path = StringUtils.removeEndIgnoreCase((String)path, (String)FEDERATED_SECURITY_SUFFIX);
            path = StringUtils.removeEndIgnoreCase((String)path, (String)"/");
            uriBuilder.setPath(path);
        }
        if (clusterUrlForParsing.getPort() != -1) {
            uriBuilder.setPort(clusterUrlForParsing.getPort());
        }
        csb.setClusterUrl(uriBuilder.build().toString());
        this.clusterUrl = csb.getClusterUrl();
        this.aadAuthenticationHelper = this.clusterUrl.toLowerCase().startsWith("http://localhost") ? null : TokenProviderFactory.createTokenProvider(csb, (HttpClient)httpClient);
        this.clientDetails = new ClientDetails(csb.getApplicationNameForTracing(), csb.getUserNameForTracing(), csb.getClientVersionForTracing());
        this.httpClient = httpClient;
        this.leaveHttpClientOpen = leaveHttpClientOpen;
    }

    @Override
    public KustoOperationResult execute(String command) throws DataServiceException, DataClientException {
        return this.execute(DEFAULT_DATABASE_NAME, command);
    }

    @Override
    public KustoOperationResult execute(String database, String command) throws DataServiceException, DataClientException {
        return this.execute(database, command, null);
    }

    @Override
    public KustoOperationResult execute(String database, String command, ClientRequestProperties properties) throws DataServiceException, DataClientException {
        return this.execute(database, command, properties, this.determineCommandType(command));
    }

    private KustoOperationResult execute(String database, String command, ClientRequestProperties properties, CommandType commandType) throws DataServiceException, DataClientException {
        return MonitoredActivity.invoke(() -> this.executeImpl(database, command, properties, commandType), commandType.getActivityTypeSuffix().concat(".execute"), this.updateAndGetExecuteTracingAttributes(database, properties));
    }

    @Override
    public KustoOperationResult executeQuery(String command) throws DataServiceException, DataClientException {
        return this.executeQuery(DEFAULT_DATABASE_NAME, command);
    }

    @Override
    public KustoOperationResult executeQuery(String database, String command) throws DataServiceException, DataClientException {
        return this.executeQuery(database, command, null);
    }

    @Override
    public KustoOperationResult executeQuery(String database, String command, ClientRequestProperties properties) throws DataServiceException, DataClientException {
        return this.execute(database, command, properties, CommandType.QUERY);
    }

    @Override
    public KustoOperationResult executeMgmt(String command) throws DataServiceException, DataClientException {
        return this.executeMgmt(DEFAULT_DATABASE_NAME, command);
    }

    @Override
    public KustoOperationResult executeMgmt(String database, String command) throws DataServiceException, DataClientException {
        return this.executeMgmt(database, command, null);
    }

    @Override
    public KustoOperationResult executeMgmt(String database, String command, ClientRequestProperties properties) throws DataServiceException, DataClientException {
        return this.execute(database, command, properties, CommandType.ADMIN_COMMAND);
    }

    private Map<String, String> updateAndGetExecuteTracingAttributes(String database, TraceableAttributes traceableAttributes) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("cluster", this.clusterUrl);
        attributes.put("database", database);
        if (traceableAttributes != null) {
            attributes.putAll(traceableAttributes.getTracingAttributes());
        }
        return attributes;
    }

    @NotNull
    private KustoOperationResult executeImpl(String database, String command, ClientRequestProperties properties, CommandType commandType) throws DataServiceException, DataClientException {
        String response = this.executeToJsonResult(database, command, properties);
        String clusterEndpoint = String.format(commandType.getEndpoint(), this.clusterUrl);
        try {
            return new KustoOperationResult(response, clusterEndpoint.endsWith("v2/rest/query") ? QUERY_ENDPOINT_VERSION : "v1");
        }
        catch (KustoServiceQueryError e) {
            throw new DataServiceException(clusterEndpoint, "Error found while parsing json response as KustoOperationResult:" + e.getMessage(), e, e.isPermanent());
        }
        catch (Exception e) {
            throw new DataClientException(clusterEndpoint, e.getMessage(), e);
        }
    }

    @Override
    public String executeToJsonResult(String command) throws DataServiceException, DataClientException {
        return this.executeToJsonResult(DEFAULT_DATABASE_NAME, command);
    }

    @Override
    public String executeToJsonResult(String database, String command) throws DataServiceException, DataClientException {
        return this.executeToJsonResult(database, command, null);
    }

    @Override
    public String executeToJsonResult(String database, String command, ClientRequestProperties properties) throws DataServiceException, DataClientException {
        Map<String, String> headers;
        if (StringUtils.isEmpty((CharSequence)database)) {
            throw new IllegalArgumentException("Database is empty");
        }
        if (StringUtils.isEmpty((CharSequence)command)) {
            throw new IllegalArgumentException("Command is empty");
        }
        command = command.trim();
        CommandType commandType = this.determineCommandType(command);
        long timeoutMs = this.determineTimeout(properties, commandType, this.clusterUrl);
        String clusterEndpoint = String.format(commandType.getEndpoint(), this.clusterUrl);
        try {
            headers = this.generateIngestAndCommandHeaders(properties, "KJC.execute", commandType.getActivityTypeSuffix());
            this.validateEndpoint();
        }
        catch (KustoClientInvalidConnectionStringException e) {
            throw new DataClientException(this.clusterUrl, e.getMessage(), e);
        }
        this.addCommandHeaders(headers);
        String jsonPayload = this.generateCommandPayload(database, command, properties);
        StringEntity requestEntity = new StringEntity(jsonPayload, ContentType.APPLICATION_JSON);
        return MonitoredActivity.invoke(() -> HttpPostUtils.post(this.httpClient, clusterEndpoint, (AbstractHttpEntity)requestEntity, timeoutMs + (long)CLIENT_SERVER_DELTA_IN_MILLISECS, headers), commandType.getActivityTypeSuffix().concat(".executeToJsonResult"));
    }

    private void validateEndpoint() throws DataServiceException, KustoClientInvalidConnectionStringException {
        if (!this.endpointValidated) {
            KustoTrustedEndpoints.validateTrustedEndpoint(this.clusterUrl, CloudInfo.retrieveCloudInfoForCluster(this.clusterUrl).getLoginEndpoint());
            this.endpointValidated = true;
        }
    }

    @Override
    public KustoOperationResult executeStreamingIngest(String database, String table, InputStream stream, ClientRequestProperties properties, String streamFormat, String mappingName, boolean leaveOpen) throws DataServiceException, DataClientException {
        if (stream == null) {
            throw new IllegalArgumentException("The provided stream is null.");
        }
        String clusterEndpoint = this.buildClusterEndpoint(database, table, streamFormat, mappingName);
        return this.executeStreamingIngestImpl(clusterEndpoint, stream, null, properties, leaveOpen);
    }

    @Override
    public KustoOperationResult executeStreamingIngestFromBlob(String database, String table, String blobUrl, ClientRequestProperties properties, String dataFormat, String mappingName) throws DataServiceException, DataClientException {
        if (blobUrl == null) {
            throw new IllegalArgumentException("The provided blobUrl is null.");
        }
        String clusterEndpoint = this.buildClusterEndpoint(database, table, dataFormat, mappingName).concat("&sourceKind=uri");
        return this.executeStreamingIngestImpl(clusterEndpoint, null, blobUrl, properties, false);
    }

    private KustoOperationResult executeStreamingIngestImpl(String clusterEndpoint, InputStream stream, String blobUrl, ClientRequestProperties properties, boolean leaveOpen) throws DataServiceException, DataClientException {
        KustoOperationResult kustoOperationResult;
        block10: {
            boolean isStreamSource = stream != null;
            Map<String, String> headers = this.generateIngestAndCommandHeaders(properties, "KJC.executeStreamingIngest" + (isStreamSource ? "" : "FromBlob"), CommandType.STREAMING_INGEST.getActivityTypeSuffix());
            if (isStreamSource) {
                headers.put("Content-Encoding", "gzip");
            }
            Long timeoutMs = this.populateHeadersAndGetTimeout(properties, headers);
            InputStream ignored = isStreamSource && !leaveOpen ? stream : null;
            try {
                this.validateEndpoint();
                InputStreamEntity entity = isStreamSource ? new InputStreamEntity((InputStream)new UncloseableStream(stream)) : new StringEntity(new IngestionSourceStorage(blobUrl).toString(), ContentType.APPLICATION_JSON);
                String response = MonitoredActivity.invoke(() -> this.lambda$executeStreamingIngestImpl$2(clusterEndpoint, (AbstractHttpEntity)entity, timeoutMs, headers), "ClientImpl.executeStreamingIngest");
                kustoOperationResult = new KustoOperationResult(response, "v1");
                if (ignored == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (KustoServiceQueryError e) {
                    throw new DataClientException(clusterEndpoint, "Error converting json response to KustoOperationResult:" + e.getMessage(), e);
                }
                catch (KustoClientInvalidConnectionStringException | IOException e) {
                    throw new DataClientException(this.clusterUrl, e.getMessage(), e);
                }
            }
            ignored.close();
        }
        return kustoOperationResult;
    }

    private Long populateHeadersAndGetTimeout(ClientRequestProperties properties, Map<String, String> headers) throws DataClientException {
        Long timeoutMs = null;
        if (properties != null) {
            timeoutMs = this.determineTimeout(properties, CommandType.STREAMING_INGEST, this.clusterUrl);
            Iterator<Map.Entry<String, Object>> iterator = properties.getOptions();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> pair = iterator.next();
                headers.put(pair.getKey(), pair.getValue().toString());
            }
        }
        if (timeoutMs == null) {
            timeoutMs = STREAMING_INGEST_TIMEOUT_IN_MILLISECS;
        }
        return timeoutMs;
    }

    private String buildClusterEndpoint(String database, String table, String format, String mappingName) {
        if (StringUtils.isBlank((CharSequence)database)) {
            throw new IllegalArgumentException("Parameter database is empty.");
        }
        if (StringUtils.isBlank((CharSequence)table)) {
            throw new IllegalArgumentException("Parameter table is empty.");
        }
        if (StringUtils.isBlank((CharSequence)format)) {
            throw new IllegalArgumentException("Parameter format is empty.");
        }
        String clusterEndpoint = String.format(CommandType.STREAMING_INGEST.getEndpoint(), this.clusterUrl, database, table, format);
        if (!StringUtils.isEmpty((CharSequence)mappingName)) {
            clusterEndpoint = clusterEndpoint.concat(String.format("&mappingName=%s", mappingName));
        }
        return clusterEndpoint;
    }

    @Override
    public InputStream executeStreamingQuery(String command) throws DataServiceException, DataClientException {
        return this.executeStreamingQuery(DEFAULT_DATABASE_NAME, command);
    }

    @Override
    public InputStream executeStreamingQuery(String database, String command) throws DataServiceException, DataClientException {
        return this.executeStreamingQuery(database, command, null);
    }

    @Override
    public InputStream executeStreamingQuery(String database, String command, ClientRequestProperties properties) throws DataServiceException, DataClientException {
        if (StringUtils.isEmpty((CharSequence)database)) {
            throw new IllegalArgumentException("Database is empty");
        }
        if (StringUtils.isEmpty((CharSequence)command)) {
            throw new IllegalArgumentException("Command is empty");
        }
        command = command.trim();
        CommandType commandType = this.determineCommandType(command);
        long timeoutMs = this.determineTimeout(properties, commandType, this.clusterUrl);
        String clusterEndpoint = String.format(commandType.getEndpoint(), this.clusterUrl);
        Map<String, String> headers = this.generateIngestAndCommandHeaders(properties, "KJC.executeStreaming", commandType.getActivityTypeSuffix());
        this.addCommandHeaders(headers);
        String jsonPayload = this.generateCommandPayload(database, command, properties);
        try {
            this.validateEndpoint();
        }
        catch (KustoClientInvalidConnectionStringException e) {
            throw new DataClientException(this.clusterUrl, e.getMessage(), e);
        }
        return MonitoredActivity.invoke(() -> HttpPostUtils.postToStreamingOutput(this.httpClient, clusterEndpoint, jsonPayload, timeoutMs + (long)CLIENT_SERVER_DELTA_IN_MILLISECS, headers), "ClientImpl.executeStreamingQuery", this.updateAndGetExecuteTracingAttributes(database, properties));
    }

    private long determineTimeout(ClientRequestProperties properties, CommandType commandType, String clusterUrl) throws DataClientException {
        Long timeoutMs;
        try {
            timeoutMs = properties == null ? null : properties.getTimeoutInMilliSec();
        }
        catch (ParseException e) {
            throw new DataClientException(clusterUrl, "Failed to parse timeout from ClientRequestProperties");
        }
        if (timeoutMs == null) {
            timeoutMs = commandType == CommandType.ADMIN_COMMAND ? COMMAND_TIMEOUT_IN_MILLISECS : QUERY_TIMEOUT_IN_MILLISECS;
        }
        return timeoutMs;
    }

    private CommandType determineCommandType(String command) {
        if (command.startsWith(ADMIN_COMMANDS_PREFIX)) {
            return CommandType.ADMIN_COMMAND;
        }
        return CommandType.QUERY;
    }

    private Map<String, String> generateIngestAndCommandHeaders(ClientRequestProperties properties, String clientRequestIdPrefix, String activityTypeSuffix) throws DataServiceException, DataClientException {
        Map<String, String> headers = this.extractTracingHeaders(properties);
        if (this.aadAuthenticationHelper != null) {
            headers.put("Authorization", String.format("Bearer %s", this.aadAuthenticationHelper.acquireAccessToken()));
        }
        String clientRequestId = properties != null && StringUtils.isNotBlank((CharSequence)properties.getClientRequestId()) ? properties.getClientRequestId() : String.format("%s;%s", clientRequestIdPrefix, UUID.randomUUID());
        headers.put("x-ms-client-request-id", clientRequestId);
        headers.put("Connection", "Keep-Alive");
        UUID activityId = UUID.randomUUID();
        String activityContext = String.format("%s%s/%s, ActivityId=%s, ParentId=%s, ClientRequestId=%s", JAVA_INGEST_ACTIVITY_TYPE_PREFIX, activityTypeSuffix, activityId, activityId, activityId, clientRequestId);
        headers.put("x-ms-activitycontext", activityContext);
        headers.replaceAll((_i, v) -> v == null ? null : v.replaceAll("[^\\x00-\\x7F]", "?"));
        return headers;
    }

    Map<String, String> extractTracingHeaders(ClientRequestProperties properties) {
        String user;
        String app;
        HashMap<String, String> headers = new HashMap<String, String>();
        String version = this.clientDetails.getClientVersionForTracing();
        if (StringUtils.isNotBlank((CharSequence)version)) {
            headers.put(CLIENT_VERSION_HEADER, version);
        }
        String string = app = properties == null || properties.getApplication() == null ? this.clientDetails.getApplicationForTracing() : properties.getApplication();
        if (StringUtils.isNotBlank((CharSequence)app)) {
            headers.put(APP_HEADER, app);
        }
        String string2 = user = properties == null || properties.getUser() == null ? this.clientDetails.getUserNameForTracing() : properties.getUser();
        if (StringUtils.isNotBlank((CharSequence)user)) {
            headers.put(USER_HEADER, user);
        }
        return headers;
    }

    private String generateCommandPayload(String database, String command, ClientRequestProperties properties) {
        ObjectNode json = this.objectMapper.createObjectNode().put("db", database).put("csl", command);
        if (properties != null) {
            json.put("properties", properties.toString());
        }
        return json.toString();
    }

    private void addCommandHeaders(Map<String, String> headers) {
        headers.put("Content-Type", "application/json; charset=utf-8");
    }

    public String getClusterUrl() {
        return this.clusterUrl;
    }

    @Override
    public void close() throws IOException {
        if (!this.leaveHttpClientOpen) {
            this.httpClient.close();
        }
    }

    private /* synthetic */ String lambda$executeStreamingIngestImpl$2(String clusterEndpoint, AbstractHttpEntity entity, Long timeoutMs, Map headers) throws DataServiceException, DataClientException {
        return HttpPostUtils.post(this.httpClient, clusterEndpoint, entity, timeoutMs + (long)CLIENT_SERVER_DELTA_IN_MILLISECS, headers);
    }
}

