/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data;

import org.apache.http.HttpHost;

public class HttpClientProperties {
    private final Integer maxIdleTime;
    private final boolean keepAlive;
    private final Integer maxKeepAliveTime;
    private final Integer maxConnectionTotal;
    private final Integer maxConnectionRoute;
    private final HttpHost proxy;

    private HttpClientProperties(HttpClientPropertiesBuilder builder) {
        this.maxIdleTime = builder.maxIdleTime;
        this.keepAlive = builder.keepAlive;
        this.maxKeepAliveTime = builder.maxKeepAliveTime;
        this.maxConnectionTotal = builder.maxConnectionsTotal;
        this.maxConnectionRoute = builder.maxConnectionsPerRoute;
        this.proxy = builder.proxy;
    }

    public static HttpClientPropertiesBuilder builder() {
        return new HttpClientPropertiesBuilder();
    }

    public Integer maxIdleTime() {
        return this.maxIdleTime;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public Integer maxKeepAliveTime() {
        return this.maxKeepAliveTime;
    }

    public Integer maxConnectionTotal() {
        return this.maxConnectionTotal;
    }

    public Integer maxConnectionRoute() {
        return this.maxConnectionRoute;
    }

    public HttpHost getProxy() {
        return this.proxy;
    }

    public static class HttpClientPropertiesBuilder {
        private Integer maxIdleTime = 120;
        private boolean keepAlive;
        private Integer maxKeepAliveTime = 120;
        private Integer maxConnectionsTotal = 40;
        private Integer maxConnectionsPerRoute = 40;
        private HttpHost proxy = null;

        private HttpClientPropertiesBuilder() {
        }

        public HttpClientPropertiesBuilder maxIdleTime(Integer maxIdleTime) {
            this.maxIdleTime = maxIdleTime;
            return this;
        }

        public HttpClientPropertiesBuilder keepAlive(boolean keepAlive) {
            this.keepAlive = keepAlive;
            return this;
        }

        public HttpClientPropertiesBuilder maxKeepAliveTime(Integer maxKeepAliveTime) {
            this.maxKeepAliveTime = maxKeepAliveTime;
            return this;
        }

        public HttpClientPropertiesBuilder maxConnectionsTotal(Integer maxConnectionsTotal) {
            this.maxConnectionsTotal = maxConnectionsTotal;
            return this;
        }

        public HttpClientPropertiesBuilder maxConnectionsPerRoute(Integer maxConnections) {
            this.maxConnectionsPerRoute = maxConnections;
            return this;
        }

        public HttpClientPropertiesBuilder proxy(HttpHost proxy) {
            this.proxy = proxy;
            return this;
        }

        public HttpClientProperties build() {
            return new HttpClientProperties(this);
        }
    }
}

