/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.auth.endpoints;

import com.microsoft.azure.kusto.data.Ensure;
import com.microsoft.azure.kusto.data.UriUtils;
import com.microsoft.azure.kusto.data.auth.CloudInfo;
import com.microsoft.azure.kusto.data.auth.endpoints.FastSuffixMatcher;
import com.microsoft.azure.kusto.data.auth.endpoints.MatchRule;
import com.microsoft.azure.kusto.data.auth.endpoints.WellKnownKustoEndpointsData;
import com.microsoft.azure.kusto.data.exceptions.DataServiceException;
import com.microsoft.azure.kusto.data.exceptions.KustoClientInvalidConnectionStringException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KustoTrustedEndpoints {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static boolean enableWellKnownKustoEndpointsValidation = true;
    private static final Map<String, FastSuffixMatcher> matchers = new TreeMap<String, FastSuffixMatcher>(String.CASE_INSENSITIVE_ORDER);
    private static FastSuffixMatcher additionalMatcher;
    private static Predicate<String> overrideMatcher;

    public static void setOverridePolicy(Predicate<String> matcher) {
        overrideMatcher = matcher;
    }

    public static void validateTrustedEndpoint(String uri, String loginEndpoint) throws KustoClientInvalidConnectionStringException {
        try {
            KustoTrustedEndpoints.validateTrustedEndpoint(new URI(uri), loginEndpoint);
        }
        catch (URISyntaxException ex) {
            throw new KustoClientInvalidConnectionStringException(ex);
        }
    }

    public static void validateTrustedEndpoint(String uri) throws KustoClientInvalidConnectionStringException {
        try {
            KustoTrustedEndpoints.validateTrustedEndpoint(new URI(uri), CloudInfo.retrieveCloudInfoForCluster(uri).getLoginEndpoint());
        }
        catch (DataServiceException | URISyntaxException ex) {
            throw new KustoClientInvalidConnectionStringException(ex);
        }
    }

    public static void validateTrustedEndpoint(URI uri, String loginEndpoint) throws KustoClientInvalidConnectionStringException {
        Ensure.argIsNotNull(uri, "uri");
        String host = uri.getHost();
        KustoTrustedEndpoints.validateHostnameIsTrusted(host != null ? host : uri.toString(), loginEndpoint);
    }

    public static void addTrustedHosts(List<MatchRule> rules, boolean replace) {
        if (rules == null || rules.isEmpty()) {
            if (replace) {
                additionalMatcher = null;
            }
            return;
        }
        additionalMatcher = FastSuffixMatcher.create(replace ? null : additionalMatcher, rules);
    }

    private static void validateHostnameIsTrusted(String hostname, String loginEndpoint) throws KustoClientInvalidConnectionStringException {
        FastSuffixMatcher matcher;
        if (UriUtils.isLocalAddress(hostname)) {
            return;
        }
        Predicate<String> override = overrideMatcher;
        if (override != null ? override.test(hostname) : (matcher = matchers.get(loginEndpoint)) != null && matcher.isMatch(hostname) != false) {
            return;
        }
        matcher = additionalMatcher;
        if (matcher != null && matcher.isMatch(hostname).booleanValue()) {
            return;
        }
        if (!enableWellKnownKustoEndpointsValidation) {
            log.warn("Can't communicate with '{}' as this hostname is currently not trusted; please see https://aka.ms/kustotrustedendpoints.", (Object)hostname);
            return;
        }
        throw new KustoClientInvalidConnectionStringException(String.format("$$ALERT[ValidateHostnameIsTrusted]: Can't communicate with '%s' as this hostname is currently not trusted; please see https://aka.ms/kustotrustedendpoints", hostname));
    }

    static {
        WellKnownKustoEndpointsData.getInstance().AllowedEndpointsByLogin.forEach((key, value) -> {
            ArrayList<MatchRule> rules = new ArrayList<MatchRule>();
            value.AllowedKustoSuffixes.forEach(suffix -> rules.add(new MatchRule((String)suffix, false)));
            value.AllowedKustoHostnames.forEach(hostname -> rules.add(new MatchRule((String)hostname, true)));
            matchers.put((String)key, FastSuffixMatcher.create(rules));
        });
        additionalMatcher = null;
        overrideMatcher = null;
    }
}

