/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.exceptions;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.microsoft.azure.kusto.data.exceptions.DataWebException;
import java.util.ArrayList;
import java.util.List;

public class KustoServiceQueryError
extends Exception {
    private final List<Exception> exceptions = new ArrayList<Exception>();

    public KustoServiceQueryError(ArrayNode jsonExceptions, boolean isOneApi, String message) {
        super(message);
        for (int j = 0; jsonExceptions != null && j < jsonExceptions.size(); ++j) {
            if (isOneApi) {
                this.exceptions.add(new DataWebException(jsonExceptions.get(j).toString()));
                continue;
            }
            this.exceptions.add(new Exception(jsonExceptions.get(j).toString()));
        }
    }

    public KustoServiceQueryError(String message) {
        super(message);
        this.exceptions.add(new Exception(message));
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    @Override
    public String toString() {
        return this.exceptions.isEmpty() ? this.getMessage() : "exceptions\":" + this.exceptions + "}";
    }

    public boolean isPermanent() {
        if (this.exceptions.size() > 0 && this.exceptions.get(0) instanceof DataWebException) {
            return ((DataWebException)this.exceptions.get(0)).getApiError().isPermanent();
        }
        return false;
    }
}

