/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.util.Context;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.microsoft.azure.kusto.data.Client;
import com.microsoft.azure.kusto.data.StreamingClient;
import com.microsoft.azure.kusto.data.Utils;
import com.microsoft.azure.kusto.data.exceptions.DataServiceException;
import com.microsoft.azure.kusto.data.exceptions.DataWebException;
import com.microsoft.azure.kusto.data.exceptions.ExceptionUtils;
import com.microsoft.azure.kusto.data.exceptions.OneApiError;
import com.microsoft.azure.kusto.data.exceptions.ThrottleException;
import com.microsoft.azure.kusto.data.exceptions.WebException;
import com.microsoft.azure.kusto.data.http.CloseParentResourcesStream;
import com.microsoft.azure.kusto.data.http.HttpRequestBuilder;
import com.microsoft.azure.kusto.data.req.RequestUtils;
import com.microsoft.azure.kusto.data.res.ResponseState;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.EofSensorInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public abstract class BaseClient
implements Client,
StreamingClient {
    private static final int EXTRA_TIMEOUT_FOR_CLIENT_SIDE = (int)TimeUnit.SECONDS.toMillis(30L);
    protected static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected HttpClient httpClient;

    public BaseClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    protected Mono<String> postAsync(HttpRequest request, long timeoutMs) {
        return this.httpClient.send(request, BaseClient.getContextTimeout(timeoutMs)).flatMap(response -> Utils.getResponseBody(response).map(responseBody -> {
            switch (response.getStatusCode()) {
                case 200: {
                    return responseBody;
                }
                case 429: {
                    throw new ThrottleException(response.getRequest().getUrl().toString());
                }
            }
            throw BaseClient.createExceptionFromResponse(response.getRequest().getUrl().toString(), response, null, responseBody);
        }).doFinally(ignore -> response.close())).onErrorMap(e -> {
            if (e instanceof DataServiceException) {
                return e;
            }
            return ExceptionUtils.createExceptionOnPost((Exception)e, request.getUrl(), "async");
        });
    }

    protected Mono<InputStream> postToStreamingOutputAsync(HttpRequest request, long timeoutMs, int currentRedirectCounter, int maxRedirectCount) {
        ResponseState state = new ResponseState();
        return this.httpClient.send(request, BaseClient.getContextTimeout(timeoutMs)).flatMap(httpResponse -> {
            state.setHttpResponse((HttpResponse)httpResponse);
            int responseStatusCode = httpResponse.getStatusCode();
            if (responseStatusCode == 200) {
                state.setReturnInputStream(true);
                return httpResponse.getBodyAsInputStream().map(inputStream -> new EofSensorInputStream((InputStream)new CloseParentResourcesStream((HttpResponse)httpResponse, (InputStream)inputStream), null));
            }
            return this.handleErrorResponse((HttpResponse)httpResponse, state, request, timeoutMs, currentRedirectCounter, maxRedirectCount);
        }).onErrorMap(IOException.class, e -> new DataServiceException(request.getUrl().toString(), "postToStreamingOutput failed to get or decompress response stream", (Exception)e, false)).onErrorMap(UncheckedIOException.class, e -> ExceptionUtils.createExceptionOnPost(e, request.getUrl(), "streaming async")).onErrorMap(Exception.class, e -> BaseClient.createExceptionFromResponse(request.getUrl().toString(), state.getHttpResponse(), e, state.getErrorFromResponse())).doFinally(ignored -> BaseClient.closeResourcesIfNeeded(state.isReturnInputStream(), state.getHttpResponse()));
    }

    private Mono<InputStream> handleErrorResponse(HttpResponse httpResponse, ResponseState state, HttpRequest request, long timeoutMs, int currentRedirectCounter, int maxRedirectCount) {
        return Utils.getResponseBody(httpResponse).flatMap(content -> {
            state.setErrorFromResponse((String)content);
            if (content.isEmpty() || content.equals("{}")) {
                throw new DataServiceException(request.getUrl().toString(), "postToStreamingOutputAsync failed to get or decompress response body.", true);
            }
            httpResponse.close();
            if (BaseClient.shouldPostToOriginalUrlDueToRedirect(httpResponse.getStatusCode(), currentRedirectCounter, maxRedirectCount)) {
                Optional<HttpHeader> redirectLocation = Optional.ofNullable(httpResponse.getHeaders().get(HttpHeaderName.LOCATION));
                return redirectLocation.filter(location -> !location.getValue().equals(request.getUrl().toString())).map(location -> {
                    HttpRequest redirectRequest = HttpRequestBuilder.fromExistingRequest(request).withURL(location.getValue()).build();
                    return this.postToStreamingOutputAsync(redirectRequest, timeoutMs, currentRedirectCounter + 1, maxRedirectCount);
                }).orElseThrow(() -> BaseClient.createExceptionFromResponse(request.getUrl().toString(), httpResponse, null, state.getErrorFromResponse()));
            }
            throw BaseClient.createExceptionFromResponse(request.getUrl().toString(), httpResponse, null, state.getErrorFromResponse());
        });
    }

    public static DataServiceException createExceptionFromResponse(String url, HttpResponse httpResponse, Exception thrownException, String errorFromResponse) {
        if (httpResponse == null) {
            return new DataServiceException(url, "POST failed to send request", thrownException, false);
        }
        String activityId = BaseClient.determineActivityId(httpResponse);
        String message = errorFromResponse;
        WebException formattedException = new WebException(errorFromResponse, httpResponse, thrownException);
        boolean isPermanent = false;
        if (!StringUtils.isBlank((CharSequence)errorFromResponse)) {
            try {
                JsonNode jsonObject = Utils.getObjectMapper().readTree(errorFromResponse);
                if (jsonObject.has("error")) {
                    formattedException = new DataWebException(errorFromResponse, httpResponse, thrownException);
                    OneApiError apiError = ((DataWebException)formattedException).getApiError();
                    message = apiError.getDescription();
                    isPermanent = apiError.isPermanent();
                } else if (jsonObject.has("message")) {
                    message = jsonObject.get("message").asText();
                }
            }
            catch (JsonProcessingException e) {
                LOGGER.debug("json processing error happened while parsing errorFromResponse {}", (Object)e.getMessage(), (Object)e);
            }
        } else {
            if (httpResponse.getStatusCode() == 403 || httpResponse.getStatusCode() == 401) {
                isPermanent = true;
            }
            message = String.format("Http StatusCode='%s'", httpResponse.getStatusCode());
        }
        return new DataServiceException(url, String.format("%s, ActivityId='%s'", message, activityId), (Exception)((Object)formattedException), isPermanent);
    }

    private static Context getContextTimeout(long timeoutMs) {
        int requestTimeout = timeoutMs > Integer.MAX_VALUE ? Integer.MAX_VALUE : Math.toIntExact(timeoutMs) + EXTRA_TIMEOUT_FOR_CLIENT_SIDE;
        return RequestUtils.contextWithTimeout(Duration.ofMillis(requestTimeout));
    }

    private static void closeResourcesIfNeeded(boolean returnInputStream, HttpResponse httpResponse) {
        if (!returnInputStream && httpResponse != null) {
            httpResponse.close();
        }
    }

    private static boolean shouldPostToOriginalUrlDueToRedirect(int status, int redirectCount, int maxRedirectCount) {
        return (status == 302 || status == 207) && redirectCount + 1 <= maxRedirectCount;
    }

    private static String determineActivityId(HttpResponse httpResponse) {
        String activityId = "";
        Optional<HttpHeader> activityIdHeader = Optional.ofNullable(httpResponse.getHeaders().get(HttpHeaderName.fromString((String)"x-ms-activity-id")));
        if (activityIdHeader.isPresent()) {
            activityId = activityIdHeader.get().getValue();
        }
        return activityId;
    }
}

