/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data;

import com.microsoft.azure.kusto.data.KustoCheckedFunction;
import com.microsoft.azure.kusto.data.exceptions.KustoDataExceptionBase;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.util.annotation.Nullable;
import reactor.util.retry.Retry;

public class ExponentialRetry<E1 extends Throwable, E2 extends Throwable> {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final int maxAttempts;
    double sleepBaseSecs;
    double maxJitterSecs;

    public ExponentialRetry(int maxAttempts) {
        this.maxAttempts = maxAttempts;
        this.sleepBaseSecs = 1.0;
        this.maxJitterSecs = 1.0;
    }

    public ExponentialRetry(int maxAttempts, double sleepBaseSecs, double maxJitterSecs) {
        this.maxAttempts = maxAttempts;
        this.sleepBaseSecs = sleepBaseSecs;
        this.maxJitterSecs = maxJitterSecs;
    }

    public ExponentialRetry(ExponentialRetry other) {
        this.maxAttempts = other.maxAttempts;
        this.sleepBaseSecs = other.sleepBaseSecs;
        this.maxJitterSecs = other.maxJitterSecs;
    }

    public <T> T execute(KustoCheckedFunction<Integer, T, E1, E2> function) throws E1, E2 {
        for (int currentAttempt = 0; currentAttempt < this.maxAttempts; ++currentAttempt) {
            log.info("execute: Attempt {}", (Object)currentAttempt);
            try {
                T result = function.apply(currentAttempt);
                if (result != null) {
                    return result;
                }
            }
            catch (Exception e) {
                log.error("execute: Error is permanent, stopping", (Throwable)e);
                throw e;
            }
            double currentSleepSecs = this.sleepBaseSecs * (double)((float)Math.pow(2.0, currentAttempt));
            double jitterSecs = (double)((float)Math.random()) * this.maxJitterSecs;
            double sleepMs = (currentSleepSecs + jitterSecs) * 1000.0;
            log.info("execute: Attempt {} failed, trying again after sleep of {} seconds", (Object)currentAttempt, (Object)(sleepMs / 1000.0));
            try {
                Thread.sleep((long)sleepMs);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("execute: Interrupted while sleeping", e);
            }
        }
        return null;
    }

    public Retry retry(@Nullable List<Class<? extends Throwable>> retriableErrorClasses) {
        return Retry.backoff((long)this.maxAttempts, (Duration)Duration.ofSeconds((long)this.sleepBaseSecs)).maxBackoff(Duration.ofSeconds(30L)).jitter(this.maxJitterSecs).filter(throwable -> ExponentialRetry.shouldRetry(throwable, retriableErrorClasses)).doAfterRetry(retrySignal -> {
            long currentAttempt = retrySignal.totalRetries() + 1L;
            log.info("Attempt {} failed.", (Object)currentAttempt);
        }).onRetryExhaustedThrow((spec, signal) -> signal.failure());
    }

    private static boolean shouldRetry(Throwable failure, List<Class<? extends Throwable>> retriableErrorClasses) {
        if (failure instanceof KustoDataExceptionBase) {
            return !((KustoDataExceptionBase)((Object)failure)).isPermanent();
        }
        if (retriableErrorClasses != null) {
            return retriableErrorClasses.stream().anyMatch(errorClass -> errorClass.isInstance(failure));
        }
        return false;
    }
}

