/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.microsoft.azure.kusto.data.KustoResultSetTable;
import com.microsoft.azure.kusto.data.Utils;
import com.microsoft.azure.kusto.data.WellKnownDataSet;
import com.microsoft.azure.kusto.data.exceptions.JsonPropertyMissingException;
import com.microsoft.azure.kusto.data.exceptions.KustoServiceQueryError;
import com.microsoft.azure.kusto.data.instrumentation.MonitoredActivity;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KustoOperationResult
implements Iterator<KustoResultSetTable> {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Map<String, WellKnownDataSet> tablesKindsMap = new HashMap<String, WellKnownDataSet>(){
        {
            this.put("QueryResult", WellKnownDataSet.PrimaryResult);
            this.put("QueryProperties", WellKnownDataSet.QueryProperties);
            this.put("QueryStatus", WellKnownDataSet.QueryCompletionInformation);
        }
    };
    private static final String TABLE_NAME_PROPERTY_NAME = "Name";
    private static final String TABLE_ID_PROPERTY_NAME = "Id";
    private static final String TABLE_KIND_PROPERTY_NAME = "Kind";
    private static final String TABLES_LIST_PROPERTY_NAME = "Tables";
    private static final String DATA_TABLE_FRAME_TYPE_PROPERTY_VALUE = "DataTable";
    private static final String FRAME_TYPE_PROPERTY_NAME = "FrameType";
    private static final String DATA_SET_COMPLETION_FRAME_TYPE_PROPERTY_VALUE = "DataSetCompletion";
    private static final String HAS_ERRORS_PROPERTY_NAME = "HasErrors";
    static final String ONE_API_ERRORS_PROPERTY_NAME = "OneApiErrors";
    private final List<KustoResultSetTable> resultTables = new ArrayList<KustoResultSetTable>();
    private final Iterator<KustoResultSetTable> it;
    private final ObjectMapper objectMapper = Utils.getObjectMapper();

    public KustoOperationResult(String response, String version) {
        MonitoredActivity.invoke(() -> {
            this.kustoOperationResultImpl(response, version);
            return null;
        }, "KustoOperationResult.createFromResponse");
        this.it = this.resultTables.iterator();
    }

    private void kustoOperationResultImpl(String response, String version) {
        if (version.contains("v2")) {
            this.createFromV2Response(response);
        } else {
            this.createFromV1Response(response);
        }
    }

    public List<KustoResultSetTable> getResultTables() {
        return this.resultTables;
    }

    @Override
    public boolean hasNext() {
        return this.it.hasNext();
    }

    @Override
    public KustoResultSetTable next() {
        return this.it.next();
    }

    public KustoResultSetTable getPrimaryResults() {
        if (this.resultTables.size() == 1) {
            return this.resultTables.get(0);
        }
        return this.resultTables.stream().filter(t -> t.getTableKind().equals((Object)WellKnownDataSet.PrimaryResult)).findFirst().orElse(null);
    }

    private void createFromV1Response(String response) {
        block8: {
            try {
                JsonNode jsonObject = this.objectMapper.readTree(response);
                if (jsonObject.has(TABLES_LIST_PROPERTY_NAME) && jsonObject.get(TABLES_LIST_PROPERTY_NAME).isArray()) {
                    ArrayNode jsonArray = (ArrayNode)jsonObject.get(TABLES_LIST_PROPERTY_NAME);
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        JsonNode table = jsonArray.get(i);
                        this.resultTables.add(new KustoResultSetTable(table));
                    }
                    break block8;
                }
                throw new JsonPropertyMissingException("Tables Property missing from V1 response json");
            }
            catch (JsonProcessingException | JsonPropertyMissingException e) {
                log.error("Json processing error occurred while parsing string to json with exception", (Throwable)e);
                throw new KustoServiceQueryError("Json processing error occurred while parsing string to json with exception " + ((Throwable)e).getMessage());
            }
        }
        if (this.resultTables.size() <= 2) {
            this.resultTables.get(0).setTableKind(WellKnownDataSet.PrimaryResult);
            this.resultTables.get(0).setTableId(Integer.toString(0));
            if (this.resultTables.size() == 2) {
                this.resultTables.get(1).setTableKind(WellKnownDataSet.QueryProperties);
                this.resultTables.get(1).setTableId(Integer.toString(1));
            }
        } else {
            KustoResultSetTable toc = this.resultTables.get(this.resultTables.size() - 1);
            toc.setTableKind(WellKnownDataSet.TableOfContents);
            toc.setTableId(Integer.toString(this.resultTables.size() - 1));
            for (int i = 0; i < this.resultTables.size() - 1; ++i) {
                toc.next();
                this.resultTables.get(i).setTableName(toc.getString(TABLE_NAME_PROPERTY_NAME));
                this.resultTables.get(i).setTableId(toc.getString(TABLE_ID_PROPERTY_NAME));
                this.resultTables.get(i).setTableKind(tablesKindsMap.get(toc.getString(TABLE_KIND_PROPERTY_NAME)));
            }
        }
    }

    private void createFromV2Response(String response) {
        block7: {
            try {
                JsonNode jsonNode = this.objectMapper.readTree(response);
                if (jsonNode.isArray()) {
                    ArrayNode jsonArray = (ArrayNode)jsonNode;
                    for (JsonNode node : jsonArray) {
                        String frameType = "";
                        if (node.has(FRAME_TYPE_PROPERTY_NAME)) {
                            frameType = node.get(FRAME_TYPE_PROPERTY_NAME).asText();
                        }
                        if (frameType.equals(DATA_SET_COMPLETION_FRAME_TYPE_PROPERTY_VALUE) && node.has(HAS_ERRORS_PROPERTY_NAME) && node.get(HAS_ERRORS_PROPERTY_NAME).asBoolean()) {
                            ArrayNode oneApiErrors = (ArrayNode)node.get(ONE_API_ERRORS_PROPERTY_NAME);
                            throw KustoServiceQueryError.fromOneApiErrorArray(oneApiErrors, true);
                        }
                        if (!frameType.equals(DATA_TABLE_FRAME_TYPE_PROPERTY_VALUE)) continue;
                        this.resultTables.add(new KustoResultSetTable(node));
                    }
                    break block7;
                }
                throw new JsonPropertyMissingException("There is no array in the response which can be parsed");
            }
            catch (JsonProcessingException | JsonPropertyMissingException jsonException) {
                log.error("Json processing error occurred while parsing string to json with exception", (Throwable)jsonException);
                throw new KustoServiceQueryError("Json processing error occurred while parsing string to json with exception " + ((Throwable)jsonException).getMessage());
            }
            catch (NullPointerException nullPointerException) {
                log.error("Null pointer exception thrown due to invalid v2 response", (Throwable)nullPointerException);
                throw new KustoServiceQueryError("Null pointer exception thrown due to invalid v2 response " + nullPointerException.getMessage());
            }
        }
    }
}

