/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class UriUtils {
    public static final String FEDERATED_SECURITY_SUFFIX = ";fed=true";

    private UriUtils() {
    }

    public static String createClusterURLFrom(String clusterURI) throws URISyntaxException {
        String path;
        URI clusterUrlForParsing = new URI(clusterURI);
        String host = clusterUrlForParsing.getHost();
        Objects.requireNonNull(clusterUrlForParsing.getAuthority(), "clusterUri must have uri authority component");
        String auth = clusterUrlForParsing.getAuthority().toLowerCase();
        if (host == null) {
            host = StringUtils.removeEndIgnoreCase((String)auth, (String)FEDERATED_SECURITY_SUFFIX);
        }
        if ((path = clusterUrlForParsing.getPath()) != null && !path.isEmpty()) {
            path = StringUtils.removeEndIgnoreCase((String)path, (String)FEDERATED_SECURITY_SUFFIX);
            path = StringUtils.removeEndIgnoreCase((String)path, (String)"/");
        }
        String clusterUri = String.format("%s://%s%s%s", clusterUrlForParsing.getScheme(), host, clusterUrlForParsing.getPort() != -1 ? ":" + clusterUrlForParsing.getPort() : "", path);
        return new URI(clusterUri).toString();
    }

    public static String setPathForUri(String uri, String path, boolean ensureTrailingSlash) throws URISyntaxException {
        path = StringUtils.prependIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        URI baseUri = new URI(uri);
        URI newUri = new URI(baseUri.getScheme(), baseUri.getAuthority(), path, baseUri.getQuery(), baseUri.getFragment());
        String pathString = newUri.toString();
        if (ensureTrailingSlash) {
            pathString = StringUtils.appendIfMissing((String)pathString, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        }
        return pathString;
    }

    public static String setPathForUri(String uri, String path) throws URISyntaxException {
        return UriUtils.setPathForUri(uri, path, false);
    }

    public static String appendPathToUri(String uri, String path) throws URISyntaxException {
        String existing = new URI(uri).getPath();
        return UriUtils.setPathForUri(uri, StringUtils.appendIfMissing((String)(existing == null ? "" : existing), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + path);
    }

    public static boolean isLocalAddress(String host) {
        if (host.equals("localhost") || host.equals("127.0.0.1") || host.equals("::1") || host.equals("[::1]")) {
            return true;
        }
        if (host.startsWith("127.") && host.length() <= 15 && host.length() >= 9) {
            for (int i = 0; i < host.length(); ++i) {
                char c = host.charAt(i);
                if (c == '.' || c >= '0' && c <= '9') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String removeExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int extensionPos = filename.lastIndexOf(46);
        int lastDirSeparator = filename.lastIndexOf(File.separatorChar);
        if (extensionPos == -1 || lastDirSeparator > extensionPos) {
            return filename;
        }
        return filename.substring(lastDirSeparator + 1, extensionPos);
    }

    public static String[] getSasAndEndpointFromResourceURL(String url) throws URISyntaxException {
        String[] parts = url.split("\\?");
        if (parts.length != 2) {
            throw new URISyntaxException(url, "URL is missing the required SAS query");
        }
        return parts;
    }

    public static String stripFileNameFromCommandLine(String cmdLine) {
        try {
            String processNameForTracing = cmdLine;
            if (processNameForTracing != null) {
                processNameForTracing = Paths.get(processNameForTracing.trim().split(" ")[0], new String[0]).getFileName().toString();
            }
            return processNameForTracing;
        }
        catch (Exception e) {
            return null;
        }
    }
}

