/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.auth;

import com.azure.core.http.HttpClient;
import com.microsoft.aad.msal4j.IAccount;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.SilentParameters;
import com.microsoft.azure.kusto.data.UriUtils;
import com.microsoft.azure.kusto.data.auth.CloudDependentTokenProviderBase;
import com.microsoft.azure.kusto.data.auth.CloudInfo;
import com.microsoft.azure.kusto.data.exceptions.DataClientException;
import com.microsoft.azure.kusto.data.instrumentation.MonitoredActivity;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.Mono;

public abstract class MsalTokenProviderBase
extends CloudDependentTokenProviderBase {
    protected static final String ERROR_ACQUIRING_APPLICATION_ACCESS_TOKEN = "Error acquiring ApplicationAccessToken";
    protected static final String ORGANIZATION_URI_SUFFIX = "organizations";
    protected static final String ERROR_INVALID_AUTHORITY_URL = "Error acquiring ApplicationAccessToken due to invalid Authority URL";
    protected static final int TIMEOUT_MS = 20000;
    private static final String PERSONAL_TENANT_IDV2_AAD = "9188040d-6c67-4c5b-b112-36a304b66dad";
    private final String authorityId;
    protected String aadAuthorityUrl;
    private String firstPartyAuthorityUrl;

    MsalTokenProviderBase(@NotNull String clusterUrl, String authorityId, @Nullable HttpClient httpClient) throws URISyntaxException {
        super(clusterUrl, httpClient);
        this.authorityId = authorityId;
    }

    @Override
    protected void initializeWithCloudInfo(CloudInfo cloudInfo) {
        super.initializeWithCloudInfo(cloudInfo);
        this.aadAuthorityUrl = this.determineAadAuthorityUrl(cloudInfo);
        this.firstPartyAuthorityUrl = cloudInfo.getFirstPartyAuthorityUrl();
        this.firstPartyAuthorityUrl = StringUtils.appendIfMissing((String)this.firstPartyAuthorityUrl, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }

    private String determineAadAuthorityUrl(CloudInfo cloudInfo) {
        String aadAuthorityUrlFromEnv = System.getenv("AadAuthorityUri");
        String authorityIdToUse = this.authorityId != null ? this.authorityId : ORGANIZATION_URI_SUFFIX;
        try {
            return UriUtils.setPathForUri(aadAuthorityUrlFromEnv == null ? cloudInfo.getLoginEndpoint() : aadAuthorityUrlFromEnv, authorityIdToUse, true);
        }
        catch (URISyntaxException e) {
            throw new DataClientException(this.clusterUrl, ERROR_INVALID_AUTHORITY_URL, e);
        }
    }

    @Override
    protected Mono<String> acquireAccessTokenImpl() {
        return Mono.fromCallable(this::acquireAccessTokenSilently).switchIfEmpty(Mono.defer(() -> MonitoredActivity.wrap(Mono.fromCallable(this::acquireNewAccessToken), this.getAuthMethod().concat(".acquireNewAccessToken"), this.getTracingAttributes()))).map(IAuthenticationResult::accessToken);
    }

    protected IAuthenticationResult acquireAccessTokenSilently() {
        try {
            return this.acquireAccessTokenSilentlyMsal();
        }
        catch (MalformedURLException e) {
            throw new DataClientException(this.clusterUrl, ERROR_INVALID_AUTHORITY_URL, e);
        }
        catch (ExecutionException | TimeoutException e) {
            return null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    protected abstract IAuthenticationResult acquireAccessTokenSilentlyMsal() throws MalformedURLException, InterruptedException, ExecutionException, TimeoutException;

    protected abstract IAuthenticationResult acquireNewAccessToken();

    SilentParameters getSilentParameters(Set<IAccount> accountSet) {
        IAccount account = this.getAccount(accountSet);
        if (account != null) {
            String authorityUrl = this.aadAuthorityUrl;
            if (account.homeAccountId() != null && account.homeAccountId().endsWith(PERSONAL_TENANT_IDV2_AAD)) {
                authorityUrl = this.firstPartyAuthorityUrl;
            }
            return SilentParameters.builder((Set)this.scopes, (IAccount)account).authorityUrl(authorityUrl).build();
        }
        return SilentParameters.builder((Set)this.scopes).authorityUrl(this.aadAuthorityUrl).build();
    }

    IAccount getAccount(Set<IAccount> accountSet) {
        if (accountSet.isEmpty()) {
            return null;
        }
        return accountSet.iterator().next();
    }
}

