/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.auth;

import com.azure.core.http.HttpClient;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.IClientCertificate;
import com.microsoft.azure.kusto.data.auth.AccessTokenTokenProvider;
import com.microsoft.azure.kusto.data.auth.ApplicationCertificateTokenProvider;
import com.microsoft.azure.kusto.data.auth.ApplicationKeyTokenProvider;
import com.microsoft.azure.kusto.data.auth.AsyncCallbackTokenProvider;
import com.microsoft.azure.kusto.data.auth.AzureCliTokenProvider;
import com.microsoft.azure.kusto.data.auth.CallbackTokenProvider;
import com.microsoft.azure.kusto.data.auth.ConnectionStringBuilder;
import com.microsoft.azure.kusto.data.auth.DeviceAuthTokenProvider;
import com.microsoft.azure.kusto.data.auth.ManagedIdentityTokenProvider;
import com.microsoft.azure.kusto.data.auth.SubjectNameIssuerTokenProvider;
import com.microsoft.azure.kusto.data.auth.TokenCredentialProvider;
import com.microsoft.azure.kusto.data.auth.TokenProviderBase;
import com.microsoft.azure.kusto.data.auth.UserPromptTokenProvider;
import java.net.URISyntaxException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.Mono;

public class TokenProviderFactory {
    private TokenProviderFactory() {
    }

    public static TokenProviderBase createTokenProvider(@NotNull ConnectionStringBuilder csb, @Nullable HttpClient httpClient) throws URISyntaxException {
        String clusterUrl = csb.getClusterUrl();
        String authorityId = csb.getAuthorityId();
        Mono<String> asyncTokenProvider = csb.getAsyncTokenProvider();
        if (StringUtils.isNotBlank((CharSequence)csb.getApplicationClientId())) {
            if (StringUtils.isNotBlank((CharSequence)csb.getApplicationKey())) {
                return new ApplicationKeyTokenProvider(clusterUrl, csb.getApplicationClientId(), csb.getApplicationKey(), authorityId, httpClient);
            }
            if (csb.isUseCertificateAuth()) {
                if (csb.shouldSendX509()) {
                    IClientCertificate clientCertificate = ClientCredentialFactory.createFromCertificateChain((PrivateKey)csb.getPrivateKey(), csb.getX509CertificateChain());
                    String applicationClientId = csb.getApplicationClientId();
                    return new SubjectNameIssuerTokenProvider(clusterUrl, applicationClientId, clientCertificate, authorityId, httpClient);
                }
                IClientCertificate clientCertificate = ClientCredentialFactory.createFromCertificate((PrivateKey)csb.getPrivateKey(), (X509Certificate)csb.getX509Certificate());
                String applicationClientId = csb.getApplicationClientId();
                return new ApplicationCertificateTokenProvider(clusterUrl, applicationClientId, clientCertificate, authorityId, httpClient);
            }
            throw new IllegalArgumentException("No token provider exists for the provided ConnectionStringBuilder");
        }
        if (StringUtils.isNotBlank((CharSequence)csb.getAccessToken())) {
            String accessToken = csb.getAccessToken();
            return new AccessTokenTokenProvider(clusterUrl, accessToken);
        }
        if (csb.getTokenProvider() != null) {
            return new CallbackTokenProvider(clusterUrl, csb.getTokenProvider());
        }
        if (asyncTokenProvider != null) {
            return new AsyncCallbackTokenProvider(clusterUrl, asyncTokenProvider);
        }
        if (csb.getCustomTokenCredential() != null) {
            return new TokenCredentialProvider(clusterUrl, csb.getCustomTokenCredential());
        }
        if (csb.isUseDeviceCodeAuth()) {
            return new DeviceAuthTokenProvider(clusterUrl, authorityId, httpClient);
        }
        if (csb.isUseManagedIdentityAuth()) {
            return new ManagedIdentityTokenProvider(clusterUrl, csb.getManagedIdentityClientId(), httpClient);
        }
        if (csb.isUseAzureCli()) {
            return new AzureCliTokenProvider(clusterUrl, httpClient);
        }
        if (csb.isUseUserPromptAuth() || csb.isAadFederatedSecurity()) {
            if (StringUtils.isNotBlank((CharSequence)csb.getUserUsernameHint())) {
                String usernameHint = csb.getUserUsernameHint();
                return new UserPromptTokenProvider(clusterUrl, usernameHint, authorityId, httpClient);
            }
            return new UserPromptTokenProvider(clusterUrl, null, authorityId, httpClient);
        }
        return null;
    }
}

