/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.http;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.util.Header;
import com.azure.core.util.HttpClientOptions;
import com.microsoft.azure.kusto.data.http.HttpClientProperties;
import java.time.Duration;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientFactory.class);

    public static HttpClient create(HttpClientProperties properties) {
        LOGGER.info("Creating new HTTP Client");
        HttpClientOptions options = new HttpClientOptions();
        if (properties == null) {
            return HttpClient.createDefault((HttpClientOptions)options);
        }
        options.setMaximumConnectionPoolSize(properties.maxConnectionTotal());
        options.setConnectionIdleTimeout(Duration.ofSeconds(properties.maxIdleTime().intValue()));
        options.readTimeout(Duration.ofSeconds(properties.readTimeout().intValue()));
        options.setHttpClientProvider(properties.provider());
        if (properties.isKeepAlive()) {
            Header keepAlive = new Header(HttpHeaderName.CONNECTION.getCaseSensitiveName(), "Keep-Alive");
            ArrayList<Header> headers = new ArrayList<Header>();
            headers.add(keepAlive);
            options.setHeaders(headers);
        }
        if (properties.getProxy() != null) {
            options.setProxyOptions(properties.getProxy());
        }
        return HttpClient.createDefault((HttpClientOptions)options);
    }
}

