/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.http;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.util.BinaryData;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.microsoft.azure.kusto.data.Utils;
import com.microsoft.azure.kusto.data.exceptions.DataClientException;
import com.microsoft.azure.kusto.data.http.HttpTracing;
import com.microsoft.azure.kusto.data.req.KustoRequest;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestBuilder {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String KUSTO_API_VERSION = "2024-12-12";
    private static final String CLIENT_VERSION_HEADER = "x-ms-client-version";
    private static final String APP_HEADER = "x-ms-app";
    private static final String USER_HEADER = "x-ms-user";
    private final HttpRequest request;

    public static HttpRequestBuilder fromExistingRequest(HttpRequest request) {
        return new HttpRequestBuilder(request);
    }

    public static HttpRequestBuilder newPost(String url) {
        return new HttpRequestBuilder(HttpMethod.POST, url);
    }

    private HttpRequestBuilder(HttpRequest request) {
        this.request = request;
    }

    public HttpRequestBuilder(HttpMethod method, String url) {
        URL cleanURL = HttpRequestBuilder.parseURLString(url);
        this.request = new HttpRequest(method, cleanURL);
    }

    public HttpRequestBuilder createCommandPayload(KustoRequest kr) {
        ObjectNode json = Utils.getObjectMapper().createObjectNode().put("db", kr.getDatabase()).put("csl", kr.getCommand());
        if (kr.getProperties() != null) {
            json.put("properties", kr.getProperties().toString());
        }
        this.request.setBody(json.toString());
        this.request.setHeader(HttpHeaderName.CONTENT_TYPE, "application/json; charset=utf-8");
        return this;
    }

    public HttpRequestBuilder withBody(BinaryData body) {
        this.request.setBody(body);
        return this;
    }

    public HttpRequestBuilder withAuthorization(String value) {
        if (value != null) {
            this.request.setHeader(HttpHeaderName.AUTHORIZATION, value);
        }
        return this;
    }

    public HttpRequestBuilder withContentEncoding(String contentEncoding) {
        if (contentEncoding != null) {
            this.request.setHeader(HttpHeaderName.CONTENT_ENCODING, contentEncoding);
        }
        return this;
    }

    public HttpRequestBuilder withContentType(String contentType) {
        if (contentType != null) {
            this.request.setHeader(HttpHeaderName.CONTENT_TYPE, contentType);
        }
        return this;
    }

    public HttpRequestBuilder withHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.request.setHeader(HttpHeaderName.fromString((String)entry.getKey()), entry.getValue());
        }
        return this;
    }

    public HttpRequestBuilder withTracing(HttpTracing tracing) {
        return this.withHeaders(this.getTracingHeaders(tracing));
    }

    public HttpRequestBuilder withURL(String url) {
        URL cleanURL = HttpRequestBuilder.parseURLString(url);
        this.request.setUrl(cleanURL);
        return this;
    }

    public HttpRequest build() {
        boolean hasAuth = this.request.getHeaders().stream().anyMatch(h -> h.getName().equalsIgnoreCase(HttpHeaderName.AUTHORIZATION.toString()));
        if (hasAuth) {
            URL url = this.request.getUrl();
            boolean isHttp = url.getProtocol().equalsIgnoreCase("http");
            boolean isLocalhost = url.getHost().equalsIgnoreCase("http://localhost");
            if (isHttp) {
                if (isLocalhost) {
                    log.warn("Sending security token to localhost over an unencrypted channel (http://)");
                } else {
                    throw new DataClientException(url.toString(), "Cannot forward security token to a remote service over an unencrypted channel (http://)");
                }
            }
        }
        this.request.setHeader(HttpHeaderName.ACCEPT_ENCODING, "gzip,deflate");
        this.request.setHeader(HttpHeaderName.ACCEPT, "application/json");
        this.request.setHeader(HttpHeaderName.fromString((String)"x-ms-version"), KUSTO_API_VERSION);
        return this.request;
    }

    @NotNull
    private static URL parseURLString(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new DataClientException(url, "Error parsing target URL in post request:" + e.getMessage(), e);
        }
    }

    private Map<String, String> getTracingHeaders(HttpTracing tracing) {
        String user;
        String app;
        HashMap<String, String> headers = new HashMap<String, String>();
        String version = tracing.getClientDetails().getClientVersionForTracing();
        if (StringUtils.isNotBlank((CharSequence)version)) {
            headers.put(CLIENT_VERSION_HEADER, version);
        }
        String string = app = tracing.getProperties() == null || tracing.getProperties().getApplication() == null ? tracing.getClientDetails().getApplicationForTracing() : tracing.getProperties().getApplication();
        if (StringUtils.isNotBlank((CharSequence)app)) {
            headers.put(APP_HEADER, app);
        }
        String string2 = user = tracing.getProperties() == null || tracing.getProperties().getUser() == null ? tracing.getClientDetails().getUserNameForTracing() : tracing.getProperties().getUser();
        if (StringUtils.isNotBlank((CharSequence)user)) {
            headers.put(USER_HEADER, user);
        }
        String clientRequestId = tracing.getProperties() != null && StringUtils.isNotBlank((CharSequence)tracing.getProperties().getClientRequestId()) ? tracing.getProperties().getClientRequestId() : String.format("%s;%s", tracing.getClientRequestIdPrefix(), UUID.randomUUID());
        headers.put("x-ms-client-request-id", clientRequestId);
        headers.put("Connection", "Keep-Alive");
        headers.replaceAll((_i, v) -> v == null ? null : v.replaceAll("[^\\x00-\\x7F]", "?"));
        return headers;
    }
}

