/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.http;

import com.microsoft.azure.kusto.data.ClientDetails;
import com.microsoft.azure.kusto.data.ClientRequestProperties;
import reactor.util.annotation.Nullable;

public class HttpTracing {
    private ClientRequestProperties properties;
    private String clientRequestIdPrefix;
    private String activityTypeSuffix;
    private ClientDetails clientDetails;

    private HttpTracing() {
    }

    @Nullable
    public ClientRequestProperties getProperties() {
        return this.properties;
    }

    public void setProperties(ClientRequestProperties properties) {
        this.properties = properties;
    }

    public String getClientRequestIdPrefix() {
        return this.clientRequestIdPrefix;
    }

    public void setClientRequestIdPrefix(String clientRequestIdPrefix) {
        this.clientRequestIdPrefix = clientRequestIdPrefix;
    }

    public String getActivityTypeSuffix() {
        return this.activityTypeSuffix;
    }

    public void setActivityTypeSuffix(String activityTypeSuffix) {
        this.activityTypeSuffix = activityTypeSuffix;
    }

    public ClientDetails getClientDetails() {
        return this.clientDetails;
    }

    public void setClientDetails(ClientDetails clientDetails) {
        this.clientDetails = clientDetails;
    }

    public static HttpTracingBuilder newBuilder() {
        return new HttpTracingBuilder();
    }

    public static class HttpTracingBuilder {
        private final HttpTracing tracing = new HttpTracing();

        public HttpTracingBuilder withClientDetails(ClientDetails clientDetails) {
            this.tracing.setClientDetails(clientDetails);
            return this;
        }

        public HttpTracingBuilder withProperties(ClientRequestProperties properties) {
            this.tracing.setProperties(properties);
            return this;
        }

        public HttpTracingBuilder withRequestPrefix(String requestPrefix) {
            this.tracing.setClientRequestIdPrefix(requestPrefix);
            return this;
        }

        public HttpTracingBuilder withActivitySuffix(String activitySuffix) {
            this.tracing.setActivityTypeSuffix(activitySuffix);
            return this;
        }

        public HttpTracing build() {
            return this.tracing;
        }
    }
}

