/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.req;

import com.microsoft.azure.kusto.data.ClientRequestProperties;
import com.microsoft.azure.kusto.data.CommandType;
import com.microsoft.azure.kusto.data.Ensure;
import reactor.util.annotation.Nullable;

public class KustoRequest {
    private static final String ADMIN_COMMANDS_PREFIX = ".";
    private String command;
    private CommandType commandType;
    private String database;
    private ClientRequestProperties properties;

    public KustoRequest(String command) {
        this.command = command;
    }

    public KustoRequest(String command, CommandType commandType) {
        this.command = command;
        this.commandType = commandType;
    }

    public KustoRequest(String command, String database) {
        this.command = command;
        this.database = database;
    }

    public KustoRequest(String command, String database, CommandType commandType) {
        this.command = command;
        this.database = database;
        this.commandType = commandType;
    }

    public KustoRequest(String command, ClientRequestProperties properties) {
        this.command = command;
        this.properties = properties;
    }

    public KustoRequest(String command, ClientRequestProperties properties, CommandType commandType) {
        this.command = command;
        this.properties = properties;
        this.commandType = commandType;
    }

    public KustoRequest(String command, String database, ClientRequestProperties properties) {
        this.command = command;
        this.database = database;
        this.properties = properties;
    }

    public KustoRequest(String command, String database, ClientRequestProperties properties, CommandType commandType) {
        this.command = command;
        this.database = database;
        this.properties = properties;
        this.commandType = commandType;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public CommandType getCommandType() {
        return this.commandType;
    }

    public void setCommandType(CommandType commandType) {
        this.commandType = commandType;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    @Nullable
    public ClientRequestProperties getProperties() {
        return this.properties;
    }

    public void setProperties(ClientRequestProperties properties) {
        this.properties = properties;
    }

    public void validateAndOptimize() {
        if (this.database == null) {
            this.database = "NetDefaultDb";
        }
        Ensure.stringIsNotEmpty(this.database, "database");
        Ensure.stringIsNotEmpty(this.command, "command");
        this.command = this.command.trim();
        if (this.commandType == null) {
            this.commandType = this.determineCommandType(this.command);
        }
    }

    public int getRedirectCount() {
        return this.properties == null ? 0 : this.properties.getRedirectCount();
    }

    private CommandType determineCommandType(String command) {
        if (command.startsWith(ADMIN_COMMANDS_PREFIX)) {
            return CommandType.ADMIN_COMMAND;
        }
        return CommandType.QUERY;
    }
}

