/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpResponse;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.retry.RetryConfig;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLException;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class Utils {
    private static final int MAX_RETRY_ATTEMPTS = 4;
    private static final long MAX_RETRY_INTERVAL = TimeUnit.SECONDS.toMillis(30L);
    private static final long BASE_INTERVAL = TimeUnit.SECONDS.toMillis(2L);
    private static final HashSet<Class<? extends IOException>> nonRetriableClasses = new HashSet<Class<? extends IOException>>(){
        {
            this.add(InterruptedIOException.class);
            this.add(UnknownHostException.class);
            this.add(NoRouteToHostException.class);
            this.add(SSLException.class);
        }
    };
    private static final IntervalFunction sleepConfig = IntervalFunction.ofExponentialRandomBackoff((long)BASE_INTERVAL, (double)1.5, (double)0.5, (long)MAX_RETRY_INTERVAL);

    public static ObjectMapper getObjectMapper() {
        return ((JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true)).addModule((Module)new JavaTimeModule())).build()).configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true).configure(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN, true).setNodeFactory(JsonNodeFactory.withExactBigDecimals((boolean)true));
    }

    private Utils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getPackageVersion() {
        try {
            Properties props = new Properties();
            try (InputStream versionFileStream = Utils.class.getResourceAsStream("/app.properties");){
                props.load(versionFileStream);
                String string = props.getProperty("version").trim();
                return string;
            }
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String formatDurationAsTimespan(Duration duration) {
        long durationInSeconds = duration.getSeconds();
        int nanos = duration.getNano();
        long hours = TimeUnit.SECONDS.toHours(durationInSeconds) % TimeUnit.DAYS.toHours(1L);
        long minutes = TimeUnit.SECONDS.toMinutes(durationInSeconds) % TimeUnit.HOURS.toMinutes(1L);
        long seconds = durationInSeconds % TimeUnit.MINUTES.toSeconds(1L);
        long days = TimeUnit.SECONDS.toDays(durationInSeconds);
        String absoluteVal = "";
        if (days != 0L) {
            absoluteVal = absoluteVal + String.format("%02d.", days);
        }
        absoluteVal = absoluteVal + String.format("%02d:%02d:%02d", hours, minutes, seconds);
        if (nanos != 0) {
            absoluteVal = absoluteVal + String.format(".%.3s", nanos);
        }
        return durationInSeconds < 0L ? "-" + absoluteVal : absoluteVal;
    }

    public static boolean isRetriableIOException(IOException ex) {
        return !nonRetriableClasses.contains(ex.getClass()) && ex.getMessage() != null && ex.getMessage().contains("timed out");
    }

    public static RetryConfig buildRetryConfig(Class<? extends Throwable> ... errorClasses) {
        return RetryConfig.custom().maxAttempts(4).intervalFunction(sleepConfig).retryExceptions((Class[])errorClasses).build();
    }

    public static RetryConfig buildRetryConfig(Predicate<Throwable> predicate) {
        return RetryConfig.custom().maxAttempts(4).intervalFunction(sleepConfig).retryOnException(predicate).build();
    }

    public static boolean isGzipResponse(HttpResponse response) {
        Optional<HttpHeader> contentEncoding = Optional.ofNullable(response.getHeaders().get(HttpHeaderName.CONTENT_ENCODING));
        return contentEncoding.filter(header -> header.getValue().contains("gzip")).isPresent();
    }

    public static Mono<String> getResponseBody(HttpResponse httpResponse) {
        return Utils.isGzipResponse(httpResponse) ? Utils.processGzipBody((Flux<ByteBuffer>)httpResponse.getBody()) : Utils.processNonGzipBody((Flux<ByteBuffer>)httpResponse.getBody());
    }

    public static Mono<String> processGzipBody(Flux<ByteBuffer> gzipBody) {
        EmbeddedChannel decoder = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.GZIP)});
        return gzipBody.reduce((Object)new StringBuilder(), (stringBuilder, byteBuffer) -> {
            decoder.writeInbound(new Object[]{Unpooled.wrappedBuffer((ByteBuffer)byteBuffer)});
            ByteBuf decompressedByteBuf = (ByteBuf)decoder.readInbound();
            if (decompressedByteBuf == null) {
                return stringBuilder;
            }
            String string = decompressedByteBuf.toString(StandardCharsets.UTF_8);
            decompressedByteBuf.release();
            if (!decoder.inboundMessages().isEmpty()) {
                throw new IllegalStateException("Expected exactly one message in the channel.");
            }
            stringBuilder.append(string);
            return stringBuilder;
        }).map(StringBuilder::toString).doFinally(ignore -> decoder.finishAndReleaseAll());
    }

    private static Mono<String> processNonGzipBody(Flux<ByteBuffer> gzipBody) {
        return gzipBody.reduce((Object)new StringBuilder(), (sb, bf) -> {
            sb.append(StandardCharsets.UTF_8.decode(bf.asReadOnlyBuffer()));
            return sb;
        }).map(StringBuilder::toString);
    }

    public static InputStream resolveInputStream(HttpResponse response, InputStream contentStream) {
        try {
            String contentEncoding = response.getHeaders().get(HttpHeaderName.CONTENT_ENCODING).getValue();
            if (contentEncoding.contains("gzip")) {
                return new GZIPInputStream(contentStream);
            }
            if (contentEncoding.contains("deflate")) {
                return new DeflaterInputStream(contentStream);
            }
            return contentStream;
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }
}

