/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.auth;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.http.HttpClient;
import com.azure.identity.AadCredentialBuilderBase;
import com.azure.identity.CredentialBuilderBase;
import com.microsoft.azure.kusto.data.UriUtils;
import com.microsoft.azure.kusto.data.auth.CloudDependentTokenProviderBase;
import com.microsoft.azure.kusto.data.auth.CloudInfo;
import com.microsoft.azure.kusto.data.exceptions.DataClientException;
import com.microsoft.azure.kusto.data.exceptions.DataServiceException;
import java.net.URISyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.Mono;

public abstract class AzureIdentityTokenProvider
extends CloudDependentTokenProviderBase {
    private String clientId;
    private final String tenantId;
    TokenCredential cred;
    TokenRequestContext tokenRequestContext;
    protected static final String ORGANIZATION_URI_SUFFIX = "organizations";
    protected static final String ERROR_INVALID_AUTHORITY_URL = "Error acquiring ApplicationAccessToken due to invalid Authority URL";

    private String determineAadAuthorityUrl(CloudInfo cloudInfo) throws DataClientException {
        String aadAuthorityUrlFromEnv = System.getenv("AadAuthorityUri");
        String authorityIdToUse = this.tenantId != null ? this.tenantId : ORGANIZATION_URI_SUFFIX;
        try {
            return UriUtils.setPathForUri(aadAuthorityUrlFromEnv == null ? cloudInfo.getLoginEndpoint() : aadAuthorityUrlFromEnv, authorityIdToUse, true);
        }
        catch (URISyntaxException e) {
            throw new DataClientException(this.clusterUrl, ERROR_INVALID_AUTHORITY_URL, e);
        }
    }

    AzureIdentityTokenProvider(@NotNull String clusterUrl, @Nullable String tenantId, @Nullable String clientId, @Nullable HttpClient httpClient) throws URISyntaxException {
        super(clusterUrl, httpClient);
        this.tenantId = tenantId;
        this.clientId = clientId;
    }

    AzureIdentityTokenProvider(@NotNull String clusterUrl, @Nullable HttpClient httpClient) throws URISyntaxException {
        this(clusterUrl, null, null, httpClient);
    }

    @Override
    protected final Mono<String> acquireAccessTokenImpl() {
        return this.cred.getToken(this.tokenRequestContext).map(AccessToken::getToken);
    }

    @Override
    protected final void initializeWithCloudInfo(CloudInfo cloudInfo) throws DataClientException, DataServiceException {
        super.initializeWithCloudInfo(cloudInfo);
        CredentialBuilderBase<?> builder = this.initBuilder();
        if (builder != null) {
            if (this.httpClient != null) {
                builder.httpClient(this.httpClient);
            }
            if (builder instanceof AadCredentialBuilderBase) {
                AadCredentialBuilderBase aadBuilder = (AadCredentialBuilderBase)builder;
                if (this.tenantId != null) {
                    aadBuilder.tenantId(this.tenantId);
                }
                aadBuilder.authorityHost(this.determineAadAuthorityUrl(cloudInfo));
                if (this.clientId == null) {
                    this.clientId = cloudInfo.getKustoClientAppId();
                }
                aadBuilder.clientId(this.clientId);
            }
        }
        this.cred = this.createTokenCredential(builder);
        this.tokenRequestContext = new TokenRequestContext().addScopes(this.scopes.toArray(new String[0]));
    }

    protected abstract CredentialBuilderBase<?> initBuilder();

    protected abstract TokenCredential createTokenCredential(CredentialBuilderBase<?> var1);
}

