/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.auth;

import com.azure.core.credential.TokenCredential;
import com.microsoft.azure.kusto.data.ClientDetails;
import com.microsoft.azure.kusto.data.StringUtils;
import com.microsoft.azure.kusto.data.auth.KcsbKeywords;
import com.microsoft.azure.kusto.data.auth.KnownKeywords;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class ConnectionStringBuilder {
    private static final KcsbKeywords KCSB_KEYWORDS = KcsbKeywords.getInstance();
    public static final String SECRET_REPLACEMENT = "****";
    public static final String DEFAULT_DATABASE_NAME = "NetDefaultDb";
    private static final String DEFAULT_DEVICE_AUTH_TENANT = "organizations";
    private String clusterUrl;
    private String usernameHint;
    private String applicationClientId;
    private String applicationKey;
    private String initialCatalog;
    private boolean sendX509;
    private boolean aadFederatedSecurity;
    private X509Certificate x509Certificate;
    private List<X509Certificate> x509CertificateChain;
    private PrivateKey privateKey;
    private String aadAuthorityId;
    private String accessToken;
    private Callable<String> tokenProvider;
    private Mono<String> asyncTokenProvider;
    private TokenCredential customTokenCredential;
    private String managedIdentityClientId;
    private boolean useDeviceCodeAuth;
    private boolean useManagedIdentityAuth;
    private boolean useAzureCli;
    private boolean useUserPromptAuth;
    private boolean useCertificateAuth;
    private String userNameForTracing;
    private String appendedClientVersionForTracing;
    private String applicationNameForTracing;

    private ConnectionStringBuilder() {
        this.aadFederatedSecurity = false;
        this.clusterUrl = null;
        this.usernameHint = null;
        this.applicationClientId = null;
        this.applicationKey = null;
        this.x509Certificate = null;
        this.x509CertificateChain = null;
        this.privateKey = null;
        this.aadAuthorityId = null;
        this.accessToken = null;
        this.tokenProvider = null;
        this.asyncTokenProvider = null;
        this.customTokenCredential = null;
        this.managedIdentityClientId = null;
        this.useDeviceCodeAuth = false;
        this.useManagedIdentityAuth = false;
        this.useAzureCli = false;
        this.useUserPromptAuth = false;
        this.useCertificateAuth = false;
        this.userNameForTracing = null;
        this.appendedClientVersionForTracing = null;
        this.applicationNameForTracing = null;
        this.sendX509 = false;
        this.initialCatalog = null;
    }

    private void assignValue(String rawKey, String value) {
        KnownKeywords parsedKey = KCSB_KEYWORDS.get(rawKey);
        switch (parsedKey) {
            case DATA_SOURCE: {
                this.clusterUrl = value;
                break;
            }
            case INITIAL_CATALOG: {
                this.initialCatalog = value;
                break;
            }
            case FEDERATED_SECURITY: {
                this.aadFederatedSecurity = Boolean.parseBoolean(value);
                break;
            }
            case APPLICATION_CLIENT_ID: {
                this.applicationClientId = value;
                break;
            }
            case APPLICATION_KEY: {
                this.applicationKey = value;
                break;
            }
            case AUTHORITY_ID: {
                this.aadAuthorityId = value;
                break;
            }
            case APPLICATION_CERTIFICATE_X5C: {
                this.sendX509 = Boolean.parseBoolean(value);
                break;
            }
            case APPLICATION_NAME_FOR_TRACING: {
                this.applicationNameForTracing = value;
                break;
            }
            case USER_NAME_FOR_TRACING: {
                this.userNameForTracing = value;
                break;
            }
            case USER_ID: {
                this.usernameHint = value;
                this.useUserPromptAuth = true;
                break;
            }
            case USER_TOKEN: 
            case APPLICATION_TOKEN: {
                this.accessToken = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected keyword error for `" + rawKey + "`. This is a bug - please report it.");
            }
        }
    }

    public String toString(boolean showSecrets) {
        LinkedHashMap<KnownKeywords, String> entries = new LinkedHashMap<KnownKeywords, String>();
        if (!StringUtils.isBlank(this.clusterUrl)) {
            entries.put(KnownKeywords.DATA_SOURCE, this.clusterUrl);
        }
        if (!StringUtils.isBlank(this.usernameHint)) {
            entries.put(KnownKeywords.USER_ID, this.usernameHint);
        }
        if (!StringUtils.isBlank(this.applicationClientId)) {
            entries.put(KnownKeywords.APPLICATION_CLIENT_ID, this.applicationClientId);
        }
        if (!StringUtils.isBlank(this.applicationKey)) {
            entries.put(KnownKeywords.APPLICATION_KEY, this.applicationKey);
        }
        if (!StringUtils.isBlank(this.aadAuthorityId)) {
            entries.put(KnownKeywords.AUTHORITY_ID, this.aadAuthorityId);
        }
        if (!StringUtils.isBlank(this.accessToken)) {
            entries.put(KnownKeywords.USER_TOKEN, this.accessToken);
        }
        if (!StringUtils.isBlank(this.applicationNameForTracing)) {
            entries.put(KnownKeywords.APPLICATION_NAME_FOR_TRACING, this.applicationNameForTracing);
        }
        if (!StringUtils.isBlank(this.userNameForTracing)) {
            entries.put(KnownKeywords.USER_NAME_FOR_TRACING, this.userNameForTracing);
        }
        StringBuilder sb = new StringBuilder();
        entries.forEach((key, value) -> sb.append(key.getCanonicalName()).append("=").append(!showSecrets && key.isSecret() ? SECRET_REPLACEMENT : value).append(";"));
        String result = sb.toString();
        if (result.endsWith(";")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public String toString() {
        return this.toString(false);
    }

    public ConnectionStringBuilder(ConnectionStringBuilder other) {
        this.clusterUrl = other.clusterUrl;
        this.usernameHint = other.usernameHint;
        this.applicationClientId = other.applicationClientId;
        this.applicationKey = other.applicationKey;
        this.x509Certificate = other.x509Certificate;
        this.x509CertificateChain = other.x509CertificateChain;
        this.privateKey = other.privateKey;
        this.aadAuthorityId = other.aadAuthorityId;
        this.accessToken = other.accessToken;
        this.tokenProvider = other.tokenProvider;
        this.asyncTokenProvider = other.asyncTokenProvider;
        this.customTokenCredential = other.customTokenCredential;
        this.managedIdentityClientId = other.managedIdentityClientId;
        this.useAzureCli = other.useAzureCli;
        this.useDeviceCodeAuth = other.useDeviceCodeAuth;
        this.useManagedIdentityAuth = other.useManagedIdentityAuth;
        this.useUserPromptAuth = other.useUserPromptAuth;
        this.userNameForTracing = other.userNameForTracing;
        this.appendedClientVersionForTracing = other.appendedClientVersionForTracing;
        this.applicationNameForTracing = other.applicationNameForTracing;
        this.sendX509 = other.sendX509;
        this.initialCatalog = other.initialCatalog;
        this.aadFederatedSecurity = other.aadFederatedSecurity;
        this.useCertificateAuth = other.useCertificateAuth;
    }

    public ConnectionStringBuilder(String connectionString) {
        if (StringUtils.isBlank(connectionString)) {
            throw new IllegalArgumentException("connectionString cannot be null or empty");
        }
        String[] connStrArr = connectionString.split(";");
        if (!connStrArr[0].contains("=")) {
            connStrArr[0] = KnownKeywords.DATA_SOURCE.getCanonicalName() + "=" + connStrArr[0];
        }
        for (String kvp : connStrArr) {
            String[] kvpArr;
            String val;
            if (StringUtils.isEmpty(kvp = kvp.trim()) || StringUtils.isEmpty(val = (kvpArr = kvp.split("="))[1].trim())) continue;
            this.assignValue(kvpArr[0], val);
        }
    }

    public String getClusterUrl() {
        return this.clusterUrl;
    }

    public void setClusterUrl(String clusterUrl) {
        this.clusterUrl = clusterUrl;
    }

    String getUserUsernameHint() {
        return this.usernameHint;
    }

    String getApplicationClientId() {
        return this.applicationClientId;
    }

    String getApplicationKey() {
        return this.applicationKey;
    }

    X509Certificate getX509Certificate() {
        return this.x509Certificate;
    }

    List<X509Certificate> getX509CertificateChain() {
        return this.x509CertificateChain;
    }

    PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    String getAuthorityId() {
        return this.aadAuthorityId;
    }

    String getAccessToken() {
        return this.accessToken;
    }

    public Callable<String> getTokenProvider() {
        return this.tokenProvider;
    }

    public Mono<String> getAsyncTokenProvider() {
        return this.asyncTokenProvider;
    }

    public TokenCredential getCustomTokenCredential() {
        return this.customTokenCredential;
    }

    public String getManagedIdentityClientId() {
        return this.managedIdentityClientId;
    }

    boolean isUseDeviceCodeAuth() {
        return this.useDeviceCodeAuth;
    }

    boolean isUseManagedIdentityAuth() {
        return this.useManagedIdentityAuth;
    }

    boolean isUseAzureCli() {
        return this.useAzureCli;
    }

    boolean isUseUserPromptAuth() {
        return this.useUserPromptAuth;
    }

    boolean isUseCertificateAuth() {
        return this.useCertificateAuth;
    }

    boolean isAadFederatedSecurity() {
        return this.aadFederatedSecurity;
    }

    boolean shouldSendX509() {
        return this.sendX509;
    }

    public String getInitialCatalog() {
        return this.initialCatalog == null ? DEFAULT_DATABASE_NAME : this.initialCatalog;
    }

    public String getUserNameForTracing() {
        return this.userNameForTracing;
    }

    public void setUserNameForTracing(String userNameForTracing) {
        this.userNameForTracing = userNameForTracing;
    }

    public String getClientVersionForTracing() {
        return this.appendedClientVersionForTracing;
    }

    @Deprecated
    public void setClientVersionForTracing(String clientVersionForTracing) {
        this.appendedClientVersionForTracing = clientVersionForTracing;
    }

    public String getApplicationNameForTracing() {
        return this.applicationNameForTracing;
    }

    public void setApplicationNameForTracing(String applicationNameForTracing) {
        this.applicationNameForTracing = applicationNameForTracing;
    }

    public static ConnectionStringBuilder createWithAadApplicationCredentials(String clusterUrl, String applicationClientId, String applicationKey) {
        return ConnectionStringBuilder.createWithAadApplicationCredentials(clusterUrl, applicationClientId, applicationKey, null);
    }

    public static ConnectionStringBuilder createWithAadApplicationCredentials(String clusterUrl, String applicationClientId, String applicationKey, String authorityId) {
        if (StringUtils.isEmpty(clusterUrl)) {
            throw new IllegalArgumentException("clusterUrl cannot be null or empty");
        }
        if (StringUtils.isEmpty(applicationClientId)) {
            throw new IllegalArgumentException("applicationClientId cannot be null or empty");
        }
        if (StringUtils.isEmpty(applicationKey)) {
            throw new IllegalArgumentException("applicationKey cannot be null or empty");
        }
        ConnectionStringBuilder csb = new ConnectionStringBuilder();
        csb.aadFederatedSecurity = true;
        csb.clusterUrl = clusterUrl;
        csb.applicationClientId = applicationClientId;
        csb.applicationKey = applicationKey;
        csb.aadAuthorityId = authorityId;
        return csb;
    }

    public static ConnectionStringBuilder createWithUserPrompt(String clusterUrl) {
        return ConnectionStringBuilder.createWithUserPrompt(clusterUrl, DEFAULT_DEVICE_AUTH_TENANT, null);
    }

    public static ConnectionStringBuilder createWithUserPrompt(String clusterUrl, String usernameHint) {
        return ConnectionStringBuilder.createWithUserPrompt(clusterUrl, DEFAULT_DEVICE_AUTH_TENANT, usernameHint);
    }

    public static ConnectionStringBuilder createWithUserPrompt(String clusterUrl, String authorityId, String usernameHint) {
        if (StringUtils.isEmpty(clusterUrl)) {
            throw new IllegalArgumentException("clusterUrl cannot be null or empty");
        }
        ConnectionStringBuilder csb = new ConnectionStringBuilder();
        csb.aadFederatedSecurity = true;
        csb.clusterUrl = clusterUrl;
        csb.aadAuthorityId = authorityId;
        csb.usernameHint = usernameHint;
        csb.useUserPromptAuth = true;
        return csb;
    }

    public static ConnectionStringBuilder createWithDeviceCode(String clusterUrl) {
        return ConnectionStringBuilder.createWithDeviceCode(clusterUrl, DEFAULT_DEVICE_AUTH_TENANT);
    }

    public static ConnectionStringBuilder createWithDeviceCode(String clusterUrl, String authorityId) {
        if (StringUtils.isEmpty(clusterUrl)) {
            throw new IllegalArgumentException("clusterUrl cannot be null or empty");
        }
        ConnectionStringBuilder csb = new ConnectionStringBuilder();
        csb.aadFederatedSecurity = true;
        csb.clusterUrl = clusterUrl;
        csb.aadAuthorityId = authorityId;
        csb.useDeviceCodeAuth = true;
        return csb;
    }

    public static ConnectionStringBuilder createWithAadApplicationCertificate(String clusterUrl, String applicationClientId, X509Certificate x509Certificate, PrivateKey privateKey) {
        return ConnectionStringBuilder.createWithAadApplicationCertificate(clusterUrl, applicationClientId, x509Certificate, privateKey, null);
    }

    public static ConnectionStringBuilder createWithAadApplicationCertificate(String clusterUrl, String applicationClientId, X509Certificate x509Certificate, PrivateKey privateKey, String authorityId) {
        if (StringUtils.isEmpty(clusterUrl)) {
            throw new IllegalArgumentException("clusterUrl cannot be null or empty");
        }
        if (StringUtils.isEmpty(applicationClientId)) {
            throw new IllegalArgumentException("applicationClientId cannot be null or empty");
        }
        if (x509Certificate == null) {
            throw new IllegalArgumentException("certificate cannot be null");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("privateKey cannot be null");
        }
        ConnectionStringBuilder csb = new ConnectionStringBuilder();
        csb.aadFederatedSecurity = true;
        csb.clusterUrl = clusterUrl;
        csb.applicationClientId = applicationClientId;
        csb.useCertificateAuth = true;
        csb.sendX509 = false;
        csb.x509Certificate = x509Certificate;
        csb.privateKey = privateKey;
        csb.aadAuthorityId = authorityId;
        return csb;
    }

    public static ConnectionStringBuilder createWithAadApplicationCertificateSubjectNameIssuer(String clusterUrl, String applicationClientId, List<X509Certificate> x509CertificateChain, PrivateKey privateKey) {
        return ConnectionStringBuilder.createWithAadApplicationCertificateSubjectNameIssuer(clusterUrl, applicationClientId, x509CertificateChain, privateKey, null);
    }

    public static ConnectionStringBuilder createWithAadApplicationCertificateSubjectNameIssuer(String clusterUrl, String applicationClientId, List<X509Certificate> x509CertificateChain, PrivateKey privateKey, String authorityId) {
        if (StringUtils.isEmpty(clusterUrl)) {
            throw new IllegalArgumentException("clusterUrl cannot be null or empty");
        }
        if (StringUtils.isEmpty(applicationClientId)) {
            throw new IllegalArgumentException("applicationClientId cannot be null or empty");
        }
        if (x509CertificateChain == null || x509CertificateChain.isEmpty()) {
            throw new IllegalArgumentException("public certificate chain cannot be null or empty");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("privateKey cannot be null");
        }
        ConnectionStringBuilder csb = new ConnectionStringBuilder();
        csb.aadFederatedSecurity = true;
        csb.clusterUrl = clusterUrl;
        csb.useCertificateAuth = true;
        csb.sendX509 = true;
        csb.applicationClientId = applicationClientId;
        csb.x509CertificateChain = x509CertificateChain;
        csb.privateKey = privateKey;
        csb.aadAuthorityId = authorityId;
        return csb;
    }

    public static ConnectionStringBuilder createWithAadAccessTokenAuthentication(String clusterUrl, String token) {
        if (StringUtils.isEmpty(clusterUrl)) {
            throw new IllegalArgumentException("clusterUrl cannot be null or empty");
        }
        if (StringUtils.isEmpty(token)) {
            throw new IllegalArgumentException("token cannot be null or empty");
        }
        ConnectionStringBuilder csb = new ConnectionStringBuilder();
        csb.aadFederatedSecurity = true;
        csb.clusterUrl = clusterUrl;
        csb.accessToken = token;
        return csb;
    }

    public static ConnectionStringBuilder createWithAadTokenProviderAuthentication(String clusterUrl, Callable<String> tokenProviderCallable) {
        if (StringUtils.isEmpty(clusterUrl)) {
            throw new IllegalArgumentException("clusterUrl cannot be null or empty");
        }
        if (tokenProviderCallable == null) {
            throw new IllegalArgumentException("tokenProviderCallback cannot be null");
        }
        ConnectionStringBuilder csb = new ConnectionStringBuilder();
        csb.aadFederatedSecurity = true;
        csb.clusterUrl = clusterUrl;
        csb.tokenProvider = tokenProviderCallable;
        return csb;
    }

    public static ConnectionStringBuilder createWithAadAsyncTokenProviderAuthentication(String clusterUrl, Mono<String> tokenProviderCallable) {
        if (StringUtils.isEmpty(clusterUrl)) {
            throw new IllegalArgumentException("clusterUrl cannot be null or empty");
        }
        if (tokenProviderCallable == null) {
            throw new IllegalArgumentException("tokenProviderCallback cannot be null");
        }
        ConnectionStringBuilder csb = new ConnectionStringBuilder();
        csb.aadFederatedSecurity = true;
        csb.clusterUrl = clusterUrl;
        csb.asyncTokenProvider = tokenProviderCallable;
        return csb;
    }

    public static ConnectionStringBuilder createWithAadManagedIdentity(String clusterUrl) {
        return ConnectionStringBuilder.createWithAadManagedIdentity(clusterUrl, null);
    }

    public static ConnectionStringBuilder createWithAadManagedIdentity(String clusterUrl, String managedIdentityClientId) {
        if (StringUtils.isEmpty(clusterUrl)) {
            throw new IllegalArgumentException("clusterUrl cannot be null or empty");
        }
        ConnectionStringBuilder csb = new ConnectionStringBuilder();
        csb.aadFederatedSecurity = true;
        csb.clusterUrl = clusterUrl;
        csb.managedIdentityClientId = managedIdentityClientId;
        csb.useManagedIdentityAuth = true;
        return csb;
    }

    public static ConnectionStringBuilder createWithAzureCli(String clusterUrl) {
        if (StringUtils.isEmpty(clusterUrl)) {
            throw new IllegalArgumentException("clusterUrl cannot be null or empty");
        }
        ConnectionStringBuilder csb = new ConnectionStringBuilder();
        csb.aadFederatedSecurity = true;
        csb.clusterUrl = clusterUrl;
        csb.useAzureCli = true;
        return csb;
    }

    public static ConnectionStringBuilder createWithTokenCredential(@NotNull String clusterUrl, @Nullable TokenCredential tokenCredential) {
        if (StringUtils.isEmpty(clusterUrl)) {
            throw new IllegalArgumentException("clusterUrl cannot be null or empty");
        }
        if (tokenCredential == null) {
            throw new IllegalArgumentException("tokenCredential cannot be null");
        }
        ConnectionStringBuilder csb = new ConnectionStringBuilder();
        csb.aadFederatedSecurity = true;
        csb.clusterUrl = clusterUrl;
        csb.customTokenCredential = tokenCredential;
        return csb;
    }

    public void setConnectorDetails(String name, String version, @Nullable String appName, @Nullable String appVersion, boolean sendUser, @Nullable String overrideUser, Map<String, String> additionalFields) {
        ClientDetails clientDetails = ClientDetails.fromConnectorDetails(name, version, sendUser, overrideUser, appName, appVersion, additionalFields);
        this.applicationNameForTracing = clientDetails.getApplicationForTracing();
        this.userNameForTracing = clientDetails.getUserNameForTracing();
    }
}

