/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.format;

import com.microsoft.azure.kusto.data.Ensure;
import com.microsoft.azure.kusto.data.StringUtils;
import com.microsoft.azure.kusto.data.format.CslFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CslStringFormat
extends CslFormat {
    private static final Set<String> KUSTO_LITERAL_PREFIX = Stream.of("H", "h").collect(Collectors.toCollection(HashSet::new));
    private static final Set<String> KUSTO_MULTILINE_QUOTE_DELIMITERS = Stream.of("```", "~~~").collect(Collectors.toCollection(HashSet::new));
    private static final Set<String> KUSTO_ESCAPE_SEQUENCES = Stream.of("\\\"", "'", "@\\\"", "@'").collect(Collectors.toCollection(HashSet::new));
    private final String value;

    public CslStringFormat(String value) {
        this.value = value;
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    String getValueAsString() {
        Ensure.stringIsNotBlank(this.value, "value");
        return this.value;
    }

    public static String parseStringLiteral(String value) {
        String multilineString;
        String result = value;
        if (KUSTO_LITERAL_PREFIX.contains(result.substring(0, 1))) {
            result = result.substring(1);
        }
        if (StringUtils.isNotBlank(multilineString = CslStringFormat.parseMultilineString(result))) {
            return multilineString;
        }
        return CslStringFormat.unescapeString(result);
    }

    private static String parseMultilineString(String quotedString) {
        for (String quoteDelimiter : KUSTO_MULTILINE_QUOTE_DELIMITERS) {
            if (!quotedString.startsWith(quoteDelimiter)) continue;
            int twiceQuoteLen = quoteDelimiter.length() * 2;
            if (quotedString.length() >= twiceQuoteLen && quotedString.endsWith(quoteDelimiter)) {
                return quotedString.substring(quoteDelimiter.length(), quotedString.length() - twiceQuoteLen);
            }
            return quotedString.substring(quoteDelimiter.length());
        }
        return null;
    }

    private static String unescapeString(String escapedString) {
        for (String escapeSequence : KUSTO_ESCAPE_SEQUENCES) {
            if (!escapedString.startsWith(escapeSequence)) continue;
            int escapeSequenceLength = escapeSequence.length() + 1;
            if (escapedString.length() < escapeSequenceLength || !escapedString.endsWith(escapeSequence)) continue;
            String unescapedString = escapedString.substring(escapeSequence.length(), escapedString.length() - escapeSequence.length());
            if ("\\\"".equals(escapeSequence) || "'".equals(escapeSequence)) {
                return StringUtils.unescapeJava(unescapedString);
            }
            if (!escapeSequence.startsWith("@")) continue;
            String quote = escapeSequence.substring(1);
            return escapedString.replaceAll(quote + quote, quote);
        }
        return escapedString;
    }
}

