/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest;

import com.microsoft.azure.kusto.data.instrumentation.MonitoredActivity;
import com.microsoft.azure.kusto.data.instrumentation.TraceableAttributes;
import com.microsoft.azure.kusto.ingest.IngestClient;
import com.microsoft.azure.kusto.ingest.IngestionProperties;
import com.microsoft.azure.kusto.ingest.exceptions.IngestionClientException;
import com.microsoft.azure.kusto.ingest.exceptions.IngestionServiceException;
import com.microsoft.azure.kusto.ingest.result.IngestionResult;
import com.microsoft.azure.kusto.ingest.source.BlobSourceInfo;
import com.microsoft.azure.kusto.ingest.source.CompressionType;
import com.microsoft.azure.kusto.ingest.source.FileSourceInfo;
import com.microsoft.azure.kusto.ingest.source.ResultSetSourceInfo;
import com.microsoft.azure.kusto.ingest.source.StreamSourceInfo;
import java.util.HashMap;
import java.util.Map;

public abstract class IngestClientBase
implements IngestClient {
    static final String INGEST_PREFIX = "ingest-";
    static final String PROTOCOL_SUFFIX = "://";

    static boolean shouldCompress(CompressionType sourceCompressionType, IngestionProperties.DataFormat dataFormat) {
        return sourceCompressionType == null && (dataFormat == null || dataFormat.isCompressible());
    }

    static String getIngestionEndpoint(String clusterUrl) {
        if (clusterUrl.contains(INGEST_PREFIX)) {
            return clusterUrl;
        }
        return clusterUrl.replaceFirst(PROTOCOL_SUFFIX, "://ingest-");
    }

    static String getQueryEndpoint(String clusterUrl) {
        if (clusterUrl.contains(INGEST_PREFIX)) {
            return clusterUrl.replaceFirst(INGEST_PREFIX, "");
        }
        return clusterUrl;
    }

    protected abstract IngestionResult ingestFromFileImpl(FileSourceInfo var1, IngestionProperties var2) throws IngestionClientException, IngestionServiceException;

    @Override
    public IngestionResult ingestFromFile(FileSourceInfo fileSourceInfo, IngestionProperties ingestionProperties) throws IngestionClientException, IngestionServiceException {
        return (IngestionResult)MonitoredActivity.invoke(() -> this.ingestFromFileImpl(fileSourceInfo, ingestionProperties), (String)this.getClientType().concat(".ingestFromFile"));
    }

    protected abstract IngestionResult ingestFromBlobImpl(BlobSourceInfo var1, IngestionProperties var2) throws IngestionClientException, IngestionServiceException;

    @Override
    public IngestionResult ingestFromBlob(BlobSourceInfo blobSourceInfo, IngestionProperties ingestionProperties) throws IngestionClientException, IngestionServiceException {
        return (IngestionResult)MonitoredActivity.invoke(() -> this.ingestFromBlobImpl(blobSourceInfo, ingestionProperties), (String)this.getClientType().concat(".ingestFromBlob"));
    }

    protected abstract IngestionResult ingestFromResultSetImpl(ResultSetSourceInfo var1, IngestionProperties var2) throws IngestionClientException, IngestionServiceException;

    @Override
    public IngestionResult ingestFromResultSet(ResultSetSourceInfo resultSetSourceInfo, IngestionProperties ingestionProperties) throws IngestionClientException, IngestionServiceException {
        return (IngestionResult)MonitoredActivity.invoke(() -> this.ingestFromResultSetImpl(resultSetSourceInfo, ingestionProperties), (String)this.getClientType().concat(".ingestFromResultSet"));
    }

    protected abstract IngestionResult ingestFromStreamImpl(StreamSourceInfo var1, IngestionProperties var2) throws IngestionClientException, IngestionServiceException;

    @Override
    public IngestionResult ingestFromStream(StreamSourceInfo streamSourceInfo, IngestionProperties ingestionProperties) throws IngestionClientException, IngestionServiceException {
        return (IngestionResult)MonitoredActivity.invoke(() -> this.ingestFromStreamImpl(streamSourceInfo, ingestionProperties), (String)this.getClientType().concat(".ingestFromStream"));
    }

    protected Map<String, String> getIngestionTraceAttributes(TraceableAttributes sourceInfo, TraceableAttributes ingestionProperties) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (sourceInfo != null) {
            attributes.putAll(sourceInfo.getTracingAttributes());
        }
        if (ingestionProperties != null) {
            attributes.putAll(ingestionProperties.getTracingAttributes());
        }
        return attributes;
    }

    protected abstract String getClientType();
}

