/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest;

import com.microsoft.azure.kusto.data.HttpClientProperties;
import com.microsoft.azure.kusto.data.auth.ConnectionStringBuilder;
import com.microsoft.azure.kusto.ingest.ManagedStreamingIngestClient;
import com.microsoft.azure.kusto.ingest.QueuedIngestClient;
import com.microsoft.azure.kusto.ingest.QueuedIngestClientImpl;
import com.microsoft.azure.kusto.ingest.StreamingIngestClient;
import java.net.URISyntaxException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.jetbrains.annotations.Nullable;

public class IngestClientFactory {
    private IngestClientFactory() {
    }

    public static QueuedIngestClient createClient(ConnectionStringBuilder csb) throws URISyntaxException {
        return IngestClientFactory.createClient(csb, null);
    }

    public static QueuedIngestClient createClient(ConnectionStringBuilder csb, @Nullable HttpClientProperties properties) throws URISyntaxException {
        return new QueuedIngestClientImpl(csb, properties);
    }

    public static StreamingIngestClient createStreamingIngestClient(ConnectionStringBuilder csb) throws URISyntaxException {
        return IngestClientFactory.createStreamingIngestClient(csb, null);
    }

    public static StreamingIngestClient createStreamingIngestClient(ConnectionStringBuilder csb, @Nullable HttpClientProperties properties) throws URISyntaxException {
        return new StreamingIngestClient(csb, properties);
    }

    public static ManagedStreamingIngestClient createManagedStreamingIngestClient(ConnectionStringBuilder ingestionEndpointConnectionStringBuilder, ConnectionStringBuilder queryEndpointConnectionStringBuilder) throws URISyntaxException {
        return IngestClientFactory.createManagedStreamingIngestClient(ingestionEndpointConnectionStringBuilder, queryEndpointConnectionStringBuilder, null);
    }

    public static ManagedStreamingIngestClient createManagedStreamingIngestClient(ConnectionStringBuilder ingestionEndpointConnectionStringBuilder, ConnectionStringBuilder queryEndpointConnectionStringBuilder, @Nullable HttpClientProperties properties) throws URISyntaxException {
        return new ManagedStreamingIngestClient(ingestionEndpointConnectionStringBuilder, queryEndpointConnectionStringBuilder, properties);
    }

    public static ManagedStreamingIngestClient createManagedStreamingIngestClient(ConnectionStringBuilder connectionStringBuilder) throws URISyntaxException {
        return IngestClientFactory.createManagedStreamingIngestClient(connectionStringBuilder, (HttpClientProperties)null);
    }

    public static ManagedStreamingIngestClient createManagedStreamingIngestClient(ConnectionStringBuilder connectionStringBuilder, @Nullable HttpClientProperties properties) throws URISyntaxException {
        return new ManagedStreamingIngestClient(connectionStringBuilder, properties);
    }

    public static ManagedStreamingIngestClient createManagedStreamingIngestClientFromEngineCsb(ConnectionStringBuilder engineConnectionStringBuilder) throws URISyntaxException {
        return IngestClientFactory.createManagedStreamingIngestClientFromEngineCsb(engineConnectionStringBuilder, null);
    }

    public static ManagedStreamingIngestClient createManagedStreamingIngestClientFromEngineCsb(ConnectionStringBuilder engineConnectionStringBuilder, @Nullable HttpClientProperties properties) throws URISyntaxException {
        return ManagedStreamingIngestClient.fromEngineConnectionString(engineConnectionStringBuilder, properties);
    }

    public static ManagedStreamingIngestClient createManagedStreamingIngestClientFromDmCsb(ConnectionStringBuilder dmConnectionStringBuilder) throws URISyntaxException {
        return IngestClientFactory.createManagedStreamingIngestClientFromDmCsb(dmConnectionStringBuilder, (HttpClientProperties)null);
    }

    public static ManagedStreamingIngestClient createManagedStreamingIngestClientFromDmCsb(ConnectionStringBuilder dmConnectionStringBuilder, @Nullable HttpClientProperties properties) throws URISyntaxException {
        return ManagedStreamingIngestClient.fromDmConnectionString(dmConnectionStringBuilder, properties);
    }

    public static ManagedStreamingIngestClient createManagedStreamingIngestClientFromDmCsb(ConnectionStringBuilder connectionStringBuilder, @Nullable CloseableHttpClient httpClient) throws URISyntaxException {
        return new ManagedStreamingIngestClient(connectionStringBuilder, httpClient);
    }
}

