/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest.resources;

import com.microsoft.azure.kusto.ingest.resources.RankedStorageAccount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RankedStorageAccountSet {
    private final Map<String, RankedStorageAccount> accounts = new HashMap<String, RankedStorageAccount>();

    public void addResultToAccount(String accountName, boolean success) {
        RankedStorageAccount account = this.accounts.get(accountName);
        if (account == null) {
            throw new IllegalArgumentException("Account " + accountName + " does not exist");
        }
        account.addResult(success);
    }

    public void addAccount(String accountName) {
        if (this.accounts.containsKey(accountName)) {
            throw new IllegalArgumentException("Account " + accountName + " already exists");
        }
        this.accounts.put(accountName, new RankedStorageAccount(accountName));
    }

    public void addAccount(RankedStorageAccount account) {
        if (this.accounts.containsKey(account.getAccountName())) {
            throw new IllegalArgumentException("Account " + account.getAccountName() + " already exists");
        }
        this.accounts.put(account.getAccountName(), account);
    }

    @Nullable
    public RankedStorageAccount getAccount(String accountName) {
        return this.accounts.get(accountName);
    }

    @NotNull
    public List<RankedStorageAccount> getRankedShuffledAccounts() {
        ArrayList<RankedStorageAccount> accounts = new ArrayList<RankedStorageAccount>(this.accounts.values());
        Collections.shuffle(accounts);
        return accounts;
    }
}

