/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest;

import com.azure.core.http.HttpClient;
import com.azure.core.http.netty.NettyAsyncHttpClientBuilder;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.microsoft.azure.kusto.data.Client;
import com.microsoft.azure.kusto.data.KustoOperationResult;
import com.microsoft.azure.kusto.data.KustoResultSetTable;
import com.microsoft.azure.kusto.data.Utils;
import com.microsoft.azure.kusto.data.auth.HttpClientWrapper;
import com.microsoft.azure.kusto.data.exceptions.DataClientException;
import com.microsoft.azure.kusto.data.exceptions.DataServiceException;
import com.microsoft.azure.kusto.data.exceptions.ThrottleException;
import com.microsoft.azure.kusto.data.instrumentation.MonitoredActivity;
import com.microsoft.azure.kusto.ingest.IngestionResourceManager;
import com.microsoft.azure.kusto.ingest.ResourceAlgorithms;
import com.microsoft.azure.kusto.ingest.exceptions.IngestionClientException;
import com.microsoft.azure.kusto.ingest.exceptions.IngestionServiceException;
import com.microsoft.azure.kusto.ingest.resources.ContainerWithSas;
import com.microsoft.azure.kusto.ingest.resources.QueueWithSas;
import com.microsoft.azure.kusto.ingest.resources.RankedStorageAccount;
import com.microsoft.azure.kusto.ingest.resources.RankedStorageAccountSet;
import com.microsoft.azure.kusto.ingest.resources.ResourceWithSas;
import com.microsoft.azure.kusto.ingest.utils.TableWithSas;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.vavr.CheckedFunction0;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.util.annotation.Nullable;

class ResourceManager
implements Closeable,
IngestionResourceManager {
    public static final String SERVICE_TYPE_COLUMN_NAME = "ServiceType";
    private static final long REFRESH_INGESTION_RESOURCES_PERIOD = TimeUnit.HOURS.toMillis(1L);
    private static final long REFRESH_INGESTION_RESOURCES_PERIOD_ON_FAILURE = TimeUnit.MINUTES.toMillis(15L);
    public static final int UPLOAD_TIMEOUT_MINUTES = 10;
    private final Client client;
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Timer timer;
    private final ReadWriteLock ingestionResourcesLock = new ReentrantReadWriteLock();
    private final ReadWriteLock authTokenLock = new ReentrantReadWriteLock();
    private final Long defaultRefreshTime;
    private final Long refreshTimeOnFailure;
    private final HttpClient httpClient;
    private final RetryConfig retryConfig;
    private RequestRetryOptions queueRequestOptions = null;
    private RankedStorageAccountSet storageAccountSet;
    private String identityToken;
    private IngestionResourceSet ingestionResourceSet;

    public ResourceManager(Client client, long defaultRefreshTime, long refreshTimeOnFailure, @Nullable CloseableHttpClient httpClient) {
        this.defaultRefreshTime = defaultRefreshTime;
        this.refreshTimeOnFailure = refreshTimeOnFailure;
        this.client = client;
        this.timer = new Timer(true);
        this.httpClient = httpClient == null ? new NettyAsyncHttpClientBuilder().responseTimeout(Duration.ofMinutes(10L)).build() : new HttpClientWrapper((org.apache.http.client.HttpClient)httpClient);
        this.retryConfig = Utils.buildRetryConfig((Class[])new Class[]{ThrottleException.class});
        this.storageAccountSet = new RankedStorageAccountSet();
        this.init();
    }

    public ResourceManager(Client client, @Nullable CloseableHttpClient httpClient) {
        this(client, REFRESH_INGESTION_RESOURCES_PERIOD, REFRESH_INGESTION_RESOURCES_PERIOD_ON_FAILURE, httpClient);
    }

    @Override
    public void close() {
        this.timer.cancel();
        this.timer.purge();
        this.timer = null;
        try {
            this.client.close();
        }
        catch (IOException e) {
            this.log.error("Couldn't close client: " + e.getMessage(), (Throwable)e);
        }
    }

    private void init() {
        class RefreshIngestionAuthTokenTask
        extends TimerTask {
            RefreshIngestionAuthTokenTask() {
            }

            @Override
            public void run() {
                block2: {
                    try {
                        ResourceManager.this.refreshIngestionAuthToken();
                        ResourceManager.this.timer.schedule((TimerTask)new RefreshIngestionAuthTokenTask(), ResourceManager.this.defaultRefreshTime);
                    }
                    catch (Exception e) {
                        ResourceManager.this.log.error("Error in refreshIngestionAuthToken. " + e.getMessage(), (Throwable)e);
                        if (ResourceManager.this.timer == null) break block2;
                        ResourceManager.this.timer.schedule((TimerTask)new RefreshIngestionAuthTokenTask(), ResourceManager.this.refreshTimeOnFailure);
                    }
                }
            }
        }
        this.timer.schedule((TimerTask)new RefreshIngestionAuthTokenTask(), 0L);
        class RefreshIngestionResourcesTask
        extends TimerTask {
            RefreshIngestionResourcesTask() {
            }

            @Override
            public void run() {
                block2: {
                    try {
                        ResourceManager.this.refreshIngestionResources();
                        ResourceManager.this.timer.schedule((TimerTask)new RefreshIngestionResourcesTask(), ResourceManager.this.defaultRefreshTime);
                    }
                    catch (Exception e) {
                        ResourceManager.this.log.error("Error in refreshIngestionResources. " + e.getMessage(), (Throwable)e);
                        if (ResourceManager.this.timer == null) break block2;
                        ResourceManager.this.timer.schedule((TimerTask)new RefreshIngestionResourcesTask(), ResourceManager.this.refreshTimeOnFailure);
                    }
                }
            }
        }
        this.timer.schedule((TimerTask)new RefreshIngestionResourcesTask(), 0L);
    }

    @Override
    public List<ContainerWithSas> getShuffledContainers() throws IngestionClientException, IngestionServiceException {
        IngestionResource containers = this.getResourceSet(() -> this.ingestionResourceSet.containers);
        return ResourceAlgorithms.getShuffledResources(this.storageAccountSet.getRankedShuffledAccounts(), containers.getResourcesList());
    }

    public List<QueueWithSas> getShuffledQueues() throws IngestionClientException, IngestionServiceException {
        IngestionResource queues = this.getResourceSet(() -> this.ingestionResourceSet.queues);
        return ResourceAlgorithms.getShuffledResources(this.storageAccountSet.getRankedShuffledAccounts(), queues.getResourcesList());
    }

    public TableWithSas getStatusTable() throws IngestionClientException, IngestionServiceException {
        return (TableWithSas)this.getResource(() -> this.ingestionResourceSet.statusTable);
    }

    public QueueWithSas getFailedQueue() throws IngestionClientException, IngestionServiceException {
        return (QueueWithSas)this.getResource(() -> this.ingestionResourceSet.failedIngestionsQueues);
    }

    public QueueWithSas getSuccessfulQueue() throws IngestionClientException, IngestionServiceException {
        return (QueueWithSas)this.getResource(() -> this.ingestionResourceSet.successfulIngestionsQueues);
    }

    public String getIdentityToken() throws IngestionServiceException, IngestionClientException {
        if (this.identityToken == null) {
            this.refreshIngestionAuthToken();
            try {
                this.authTokenLock.readLock().lock();
                if (this.identityToken == null) {
                    throw new IngestionServiceException("Unable to get Identity token");
                }
            }
            finally {
                this.authTokenLock.readLock().unlock();
            }
        }
        return this.identityToken;
    }

    public void setQueueRequestOptions(RequestRetryOptions queueRequestOptions) {
        this.queueRequestOptions = queueRequestOptions;
    }

    private <T> T getResource(Callable<IngestionResource<T>> resourceGetter) throws IngestionClientException, IngestionServiceException {
        return this.getResourceSet(resourceGetter).nextResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> IngestionResource<T> getResourceSet(Callable<IngestionResource<T>> resourceGetter) throws IngestionClientException, IngestionServiceException {
        IngestionResource<T> resource = null;
        try {
            resource = resourceGetter.call();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resource == null || resource.empty()) {
            this.refreshIngestionResources();
            this.ingestionResourcesLock.readLock().lock();
            try {
                resource = resourceGetter.call();
            }
            catch (Exception exception) {
            }
            finally {
                this.ingestionResourcesLock.readLock().unlock();
            }
            if (resource == null || resource.empty()) {
                throw new IngestionServiceException("Unable to get ingestion resources for this type: " + (resource == null ? "" : resource.resourceType));
            }
        }
        return resource;
    }

    private void addIngestionResource(IngestionResourceSet ingestionResourceSet, String resourceTypeName, String storageUrl) throws URISyntaxException {
        ResourceType resourceType = ResourceType.findByResourceTypeName(resourceTypeName);
        switch (resourceType) {
            case TEMP_STORAGE: {
                ingestionResourceSet.containers.addResource(new ContainerWithSas(storageUrl, this.httpClient));
                break;
            }
            case INGESTIONS_STATUS_TABLE: {
                ingestionResourceSet.statusTable.addResource(new TableWithSas(storageUrl, this.httpClient));
                break;
            }
            case SECURED_READY_FOR_AGGREGATION_QUEUE: {
                ingestionResourceSet.queues.addResource(new QueueWithSas(storageUrl, this.httpClient, this.queueRequestOptions));
                break;
            }
            case SUCCESSFUL_INGESTIONS_QUEUE: {
                ingestionResourceSet.successfulIngestionsQueues.addResource(new QueueWithSas(storageUrl, this.httpClient, this.queueRequestOptions));
                break;
            }
            case FAILED_INGESTIONS_QUEUE: {
                ingestionResourceSet.failedIngestionsQueues.addResource(new QueueWithSas(storageUrl, this.httpClient, this.queueRequestOptions));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)resourceType));
            }
        }
    }

    private void refreshIngestionResources() throws IngestionServiceException, IngestionClientException {
        MonitoredActivity.invoke(() -> {
            this.refreshIngestionResourcesImpl();
            return null;
        }, (String)"ResourceManager.refreshIngestionResource");
    }

    private void refreshIngestionResourcesImpl() throws IngestionClientException, IngestionServiceException {
        if (this.ingestionResourcesLock.writeLock().tryLock()) {
            try {
                this.log.info("Refreshing Ingestion Resources");
                IngestionResourceSet ingestionResourceSet = new IngestionResourceSet();
                Retry retry = Retry.of((String)"get ingestion resources", (RetryConfig)this.retryConfig);
                CheckedFunction0 retryExecute = Retry.decorateCheckedSupplier((Retry)retry, (CheckedFunction0 & Serializable)() -> this.client.execute(".show ingestion resources"));
                KustoOperationResult ingestionResourcesResults = (KustoOperationResult)retryExecute.apply();
                if (ingestionResourcesResults != null) {
                    KustoResultSetTable table = ingestionResourcesResults.getPrimaryResults();
                    while (table.next()) {
                        String resourceTypeName = table.getString(0);
                        String storageUrl = table.getString(1);
                        this.addIngestionResource(ingestionResourceSet, resourceTypeName, storageUrl);
                    }
                }
                this.populateStorageAccounts(ingestionResourceSet);
                this.ingestionResourceSet = ingestionResourceSet;
                this.log.info("Refreshing Ingestion Resources Finished");
            }
            catch (DataServiceException e) {
                throw new IngestionServiceException(e.getIngestionSource(), "Error refreshing IngestionResources. " + e.getMessage(), (Exception)((Object)e));
            }
            catch (DataClientException e) {
                throw new IngestionClientException(e.getIngestionSource(), "Error refreshing IngestionResources. " + e.getMessage(), (Exception)((Object)e));
            }
            catch (Throwable e) {
                throw new IngestionClientException(e.getMessage(), e);
            }
            finally {
                this.ingestionResourcesLock.writeLock().unlock();
            }
        }
    }

    private void populateStorageAccounts(IngestionResourceSet ingestionResourceSet) {
        RankedStorageAccountSet tempAccount = new RankedStorageAccountSet();
        Stream queueStream = ingestionResourceSet.queues == null ? Stream.empty() : ingestionResourceSet.queues.getResourcesList().stream();
        Stream containerStream = ingestionResourceSet.containers == null ? Stream.empty() : ingestionResourceSet.containers.getResourcesList().stream();
        Stream.concat(queueStream, containerStream).forEach(resource -> {
            String accountName = resource.getAccountName();
            if (tempAccount.getAccount(accountName) != null) {
                return;
            }
            RankedStorageAccount previousAccount = this.storageAccountSet.getAccount(accountName);
            if (previousAccount != null) {
                tempAccount.addAccount(previousAccount);
            } else {
                tempAccount.addAccount(accountName);
            }
        });
        this.storageAccountSet = tempAccount;
    }

    private void refreshIngestionAuthToken() throws IngestionServiceException, IngestionClientException {
        MonitoredActivity.invoke(() -> {
            this.refreshIngestionAuthTokenImpl();
            return null;
        }, (String)"ResourceManager.refreshIngestionAuthToken");
    }

    private void refreshIngestionAuthTokenImpl() throws IngestionClientException, IngestionServiceException {
        if (this.authTokenLock.writeLock().tryLock()) {
            try {
                this.log.info("Refreshing Ingestion Auth Token");
                Retry retry = Retry.of((String)"get Ingestion Auth Token resources", (RetryConfig)this.retryConfig);
                CheckedFunction0 retryExecute = Retry.decorateCheckedSupplier((Retry)retry, (CheckedFunction0 & Serializable)() -> this.client.execute(".get kusto identity token"));
                KustoOperationResult identityTokenResult = (KustoOperationResult)retryExecute.apply();
                if (identityTokenResult != null && identityTokenResult.hasNext() && !identityTokenResult.getResultTables().isEmpty()) {
                    KustoResultSetTable resultTable = identityTokenResult.next();
                    resultTable.next();
                    this.identityToken = resultTable.getString(0);
                }
            }
            catch (DataServiceException e) {
                throw new IngestionServiceException(e.getIngestionSource(), "Error refreshing IngestionAuthToken. " + e.getMessage(), (Exception)((Object)e));
            }
            catch (DataClientException e) {
                throw new IngestionClientException(e.getIngestionSource(), "Error refreshing IngestionAuthToken. " + e.getMessage(), (Exception)((Object)e));
            }
            catch (Throwable e) {
                throw new IngestionClientException(e.getMessage(), e);
            }
            finally {
                this.authTokenLock.writeLock().unlock();
            }
        }
    }

    protected String retrieveServiceType() {
        this.log.info("Getting version to determine endpoint's ServiceType");
        try {
            KustoOperationResult versionResult = this.client.execute(".show version");
            if (versionResult != null && versionResult.hasNext() && !versionResult.getResultTables().isEmpty()) {
                KustoResultSetTable resultTable = versionResult.next();
                resultTable.next();
                return resultTable.getString(SERVICE_TYPE_COLUMN_NAME);
            }
        }
        catch (DataServiceException e) {
            this.log.warn("Couldn't retrieve ServiceType because of a service exception executing '.show version'");
            return null;
        }
        catch (DataClientException e) {
            this.log.warn("Couldn't retrieve ServiceType because of a client exception executing '.show version'");
            return null;
        }
        this.log.warn("Couldn't retrieve ServiceType because '.show version' didn't return any records");
        return null;
    }

    @Override
    public void reportIngestionResult(ResourceWithSas<?> resource, boolean success) {
        if (this.storageAccountSet == null) {
            this.log.warn("StorageAccountSet is null");
        }
        this.storageAccountSet.addResultToAccount(resource.getAccountName(), success);
    }

    private static class IngestionResourceSet {
        IngestionResource<ContainerWithSas> containers = new IngestionResource(ResourceType.TEMP_STORAGE);
        IngestionResource<TableWithSas> statusTable = new IngestionResource(ResourceType.INGESTIONS_STATUS_TABLE);
        IngestionResource<QueueWithSas> queues = new IngestionResource(ResourceType.SECURED_READY_FOR_AGGREGATION_QUEUE);
        IngestionResource<QueueWithSas> successfulIngestionsQueues = new IngestionResource(ResourceType.SUCCESSFUL_INGESTIONS_QUEUE);
        IngestionResource<QueueWithSas> failedIngestionsQueues = new IngestionResource(ResourceType.FAILED_INGESTIONS_QUEUE);

        private IngestionResourceSet() {
        }
    }

    private static class IngestionResource<T> {
        final ResourceType resourceType;
        int roundRobinIdx = 0;
        List<T> resourcesList;

        IngestionResource(ResourceType resourceType) {
            this.resourceType = resourceType;
            this.resourcesList = new ArrayList<T>();
        }

        public List<T> getResourcesList() {
            return this.resourcesList;
        }

        void addResource(T resource) {
            this.resourcesList.add(resource);
        }

        T nextResource() {
            this.roundRobinIdx = (this.roundRobinIdx + 1) % this.resourcesList.size();
            return this.resourcesList.get(this.roundRobinIdx);
        }

        boolean empty() {
            return this.resourcesList.isEmpty();
        }
    }

    static enum ResourceType {
        SECURED_READY_FOR_AGGREGATION_QUEUE("SecuredReadyForAggregationQueue"),
        FAILED_INGESTIONS_QUEUE("FailedIngestionsQueue"),
        SUCCESSFUL_INGESTIONS_QUEUE("SuccessfulIngestionsQueue"),
        TEMP_STORAGE("TempStorage"),
        INGESTIONS_STATUS_TABLE("IngestionsStatusTable");

        private final String resourceTypeName;

        private ResourceType(String resourceTypeName) {
            this.resourceTypeName = resourceTypeName;
        }

        public static ResourceType findByResourceTypeName(String resourceTypeName) {
            for (ResourceType resourceType : ResourceType.values()) {
                if (!resourceType.resourceTypeName.equalsIgnoreCase(resourceTypeName)) continue;
                return resourceType;
            }
            throw new IllegalArgumentException(resourceTypeName);
        }

        String getResourceTypeName() {
            return this.resourceTypeName;
        }
    }
}

