/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest.resources;

import com.microsoft.azure.kusto.ingest.resources.RankedStorageAccount;
import com.microsoft.azure.kusto.ingest.utils.DefaultRandomProvider;
import com.microsoft.azure.kusto.ingest.utils.RandomProvider;
import com.microsoft.azure.kusto.ingest.utils.SystemTimeProvider;
import com.microsoft.azure.kusto.ingest.utils.TimeProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RankedStorageAccountSet {
    private static final int DEFAULT_BUCKET_COUNT = 6;
    private static final int DEFAULT_BUCKET_DURATION_MILLIS = 10000;
    private static final int[] DEFAULT_TIERS = new int[]{90, 70, 30, 0};
    public static final TimeProvider DEFAULT_TIME_PROVIDER = new SystemTimeProvider();
    public static final RandomProvider DEFAULT_RANDOM_PROVIDER = new DefaultRandomProvider();
    private final Map<String, RankedStorageAccount> accounts;
    private final int bucketCount;
    private final int bucketDurationMillis;
    private final int[] tiers;
    private final TimeProvider timeProvider;
    private final RandomProvider randomProvider;

    public RankedStorageAccountSet(int bucketCount, int bucketDurationMillis, int[] tiers, TimeProvider timeProvider, RandomProvider randomProvider) {
        this.bucketCount = bucketCount;
        this.bucketDurationMillis = bucketDurationMillis;
        this.tiers = tiers;
        this.timeProvider = timeProvider;
        this.randomProvider = randomProvider;
        this.accounts = new HashMap<String, RankedStorageAccount>();
    }

    public RankedStorageAccountSet() {
        this(6, 10000, DEFAULT_TIERS, DEFAULT_TIME_PROVIDER, DEFAULT_RANDOM_PROVIDER);
    }

    public void addResultToAccount(String accountName, boolean success) {
        RankedStorageAccount account = this.accounts.get(accountName);
        if (account == null) {
            throw new IllegalArgumentException("Account " + accountName + " does not exist");
        }
        account.addResult(success);
    }

    public void addAccount(String accountName) {
        if (this.accounts.containsKey(accountName)) {
            throw new IllegalArgumentException("Account " + accountName + " already exists");
        }
        this.accounts.put(accountName, new RankedStorageAccount(accountName, this.bucketCount, this.bucketDurationMillis, this.timeProvider));
    }

    public void addAccount(RankedStorageAccount account) {
        if (this.accounts.containsKey(account.getAccountName())) {
            throw new IllegalArgumentException("Account " + account.getAccountName() + " already exists");
        }
        this.accounts.put(account.getAccountName(), account);
    }

    @Nullable
    public RankedStorageAccount getAccount(String accountName) {
        return this.accounts.get(accountName);
    }

    @NotNull
    public List<RankedStorageAccount> getRankedShuffledAccounts() {
        ArrayList tiersList = new ArrayList();
        for (int i = 0; i < this.tiers.length; ++i) {
            tiersList.add(new ArrayList());
        }
        block1: for (RankedStorageAccount rankedStorageAccount : this.accounts.values()) {
            double rankPercentage = rankedStorageAccount.getRank() * 100.0;
            for (int i = 0; i < this.tiers.length; ++i) {
                if (!(rankPercentage >= (double)this.tiers[i])) continue;
                ((List)tiersList.get(i)).add(rankedStorageAccount);
                continue block1;
            }
        }
        for (List list : tiersList) {
            this.randomProvider.shuffle(list);
        }
        return tiersList.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }
}

