/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest;

import com.microsoft.azure.kusto.ingest.IngestionProperties;
import com.microsoft.azure.kusto.ingest.ManagedStreamingQueuingPolicyPredicator;

public class ManagedStreamingQueuingPolicy
implements ManagedStreamingQueuingPolicyPredicator {
    static final int MAX_STREAMING_UNCOMPRESSED_RAW_SIZE_BYTES = 0x400000;
    static final int MAX_STREAMING_STREAM_SIZE_BYTES = 0xA00000;
    static final int MAX_STREAMING_RAW_SIZE_BYTES = 0x600000;
    static final double JSON_UNCOMPRESSED_FACTOR = 1.5;
    static final int NON_BINARY_FACTOR = 2;
    static final double BINARY_COMPRESSED_FACTOR = 2.0;
    static final double BINARY_UNCOMPRESSED_FACTOR = 1.5;
    static ManagedStreamingQueuingPolicy Default = new ManagedStreamingQueuingPolicy();

    @Override
    public boolean shouldUseQueuedIngestion(long dataSize, long rawDataSize, boolean compressed, IngestionProperties.DataFormat dataFormat) {
        if (rawDataSize > 0L) {
            return rawDataSize > 0x600000L;
        }
        if (dataSize <= 0L) {
            return false;
        }
        if (dataSize > 0xA00000L) {
            return true;
        }
        if (!dataFormat.isCompressible()) {
            if (compressed) {
                return (double)dataSize * 2.0 > 4194304.0;
            }
            return (double)dataSize * 1.5 > 4194304.0;
        }
        if (compressed) {
            return dataSize * 2L > 0x400000L;
        }
        if (dataFormat.isJsonFormat()) {
            return (double)dataSize / 1.5 > 4194304.0;
        }
        return dataSize / 2L > 0x400000L;
    }
}

