/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest.resources;

import com.microsoft.azure.kusto.ingest.utils.TimeProvider;
import java.util.ArrayDeque;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RankedStorageAccount {
    private final ArrayDeque<Bucket> buckets = new ArrayDeque();
    private final ReadWriteLock bucketsLock = new ReentrantReadWriteLock();
    private final String accountName;
    private final int maxNumberOfBuckets;
    private final int bucketDurationMillis;
    private final TimeProvider timeProvider;
    private long lastActionTimestamp;

    public RankedStorageAccount(String accountName, int maxNumberOfBuckets, int bucketDurationMillis, TimeProvider timeProvider) {
        this.accountName = accountName;
        this.maxNumberOfBuckets = maxNumberOfBuckets;
        this.bucketDurationMillis = bucketDurationMillis;
        this.timeProvider = timeProvider;
        this.lastActionTimestamp = timeProvider.currentTimeMillis();
    }

    public void addResult(boolean success) {
        Bucket lastBucket = this.adjustForTimePassed();
        ++lastBucket.totalCount;
        if (success) {
            ++lastBucket.successCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bucket adjustForTimePassed() {
        if (this.buckets.isEmpty()) {
            Bucket b = new Bucket();
            try {
                this.bucketsLock.writeLock().lock();
                this.buckets.push(b);
            }
            finally {
                this.bucketsLock.writeLock().unlock();
            }
            this.lastActionTimestamp = this.timeProvider.currentTimeMillis();
            return b;
        }
        long timePassed = this.timeProvider.currentTimeMillis() - this.lastActionTimestamp;
        long bucketsToCreate = timePassed / (long)this.bucketDurationMillis;
        if (bucketsToCreate == 0L) {
            return this.buckets.peek();
        }
        try {
            this.bucketsLock.writeLock().lock();
            if (bucketsToCreate >= (long)this.maxNumberOfBuckets) {
                this.buckets.clear();
                this.buckets.push(new Bucket());
            } else {
                int i = 0;
                while ((long)i < bucketsToCreate) {
                    this.buckets.push(new Bucket());
                    if (this.buckets.size() > this.maxNumberOfBuckets) {
                        this.buckets.poll();
                    }
                    ++i;
                }
            }
        }
        finally {
            this.bucketsLock.writeLock().unlock();
        }
        this.lastActionTimestamp = this.timeProvider.currentTimeMillis();
        return this.buckets.peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getRank() {
        if (this.buckets.isEmpty()) {
            return 1.0;
        }
        int bucketWeight = this.buckets.size() + 1;
        double rank = 0.0;
        double totalWeight = 0.0;
        try {
            this.bucketsLock.readLock().lock();
            for (Bucket bucket : this.buckets) {
                if (bucket.totalCount == 0) {
                    --bucketWeight;
                    continue;
                }
                double successRate = (double)bucket.successCount / (double)bucket.totalCount;
                rank += successRate * (double)bucketWeight;
                totalWeight += (double)bucketWeight;
                --bucketWeight;
            }
        }
        finally {
            this.bucketsLock.readLock().unlock();
        }
        return rank / totalWeight;
    }

    public String getAccountName() {
        return this.accountName;
    }

    static class Bucket {
        public int successCount = 0;
        public int totalCount = 0;
    }
}

