/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest.source;

import com.microsoft.azure.kusto.data.Ensure;
import com.microsoft.azure.kusto.ingest.source.AbstractSourceInfo;
import com.microsoft.azure.kusto.ingest.source.CompressionType;
import java.util.Map;
import java.util.UUID;

public class BlobSourceInfo
extends AbstractSourceInfo {
    private String blobPath;
    private CompressionType compressionType;

    public String getBlobPath() {
        return this.blobPath;
    }

    public void setBlobPath(String blobPath) {
        this.blobPath = blobPath;
    }

    public BlobSourceInfo(String blobPath) {
        this.blobPath = blobPath;
    }

    public BlobSourceInfo(String blobPath, long rawSizeInBytes) {
        this(blobPath);
        this.setRawSizeInBytes(rawSizeInBytes);
    }

    public BlobSourceInfo(String blobPath, long rawSizeInBytes, CompressionType compressionType) {
        this(blobPath);
        this.compressionType = compressionType;
        this.setRawSizeInBytes(rawSizeInBytes);
    }

    public BlobSourceInfo(String blobPath, long rawSizeInBytes, UUID sourceId) {
        this(blobPath, rawSizeInBytes);
        this.setSourceId(sourceId);
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(CompressionType compressionType) {
        this.compressionType = compressionType;
    }

    @Override
    public void validate() {
        Ensure.stringIsNotBlank((String)this.blobPath, (String)"blobPath");
    }

    @Override
    public Map<String, String> getTracingAttributes() {
        Map<String, String> attributes = super.getTracingAttributes();
        attributes.put("resource", this.blobPath);
        UUID sourceId = this.getSourceId();
        if (sourceId != null) {
            attributes.put("sourceId", sourceId.toString());
        }
        return attributes;
    }
}

